/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.services.jnlp;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.services.FileAccess;
import org.freehep.application.services.ServiceManager;
import org.freehep.application.services.jnlp.JNLPFileAccess;
import org.freehep.application.services.jnlp.ProgressDialog;

public class JNLPServiceManager
implements ServiceManager {
    private FileOpenService fileOpenService;
    private PrintService printService;
    private BasicService basicService;
    private PersistenceService persistenceService;
    private DownloadService downloadService;

    private PrintService createPrintService() {
        try {
            return (PrintService)javax.jnlp.ServiceManager.lookup((String)"javax.jnlp.PrintService");
        }
        catch (UnavailableServiceException x) {
            throw new RuntimeException("Could not find javax.jnlp.PrintService");
        }
    }

    private BasicService createBasicService() {
        try {
            return (BasicService)javax.jnlp.ServiceManager.lookup((String)"javax.jnlp.BasicService");
        }
        catch (UnavailableServiceException x) {
            throw new RuntimeException("Could not find javax.jnlp.BasicService");
        }
    }

    private FileOpenService createFileOpenService() {
        try {
            return (FileOpenService)javax.jnlp.ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
        }
        catch (UnavailableServiceException x) {
            throw new RuntimeException("Could not find javax.jnlp.FileOpenService");
        }
    }

    private PersistenceService createPersistenceService() {
        try {
            return (PersistenceService)javax.jnlp.ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
        }
        catch (UnavailableServiceException x) {
            throw new RuntimeException("Could not find javax.jnlp.PersistenceService");
        }
    }

    private DownloadService createDownloadService() {
        try {
            return (DownloadService)javax.jnlp.ServiceManager.lookup((String)"javax.jnlp.DownloadService");
        }
        catch (UnavailableServiceException x) {
            throw new RuntimeException("Could not find javax.jnlp.DownloadService");
        }
    }

    public PageFormat getDefaultPage() {
        if (this.printService == null) {
            this.printService = this.createPrintService();
        }
        return this.printService.getDefaultPage();
    }

    public boolean print(Pageable document) {
        if (this.printService == null) {
            this.printService = this.createPrintService();
        }
        return this.printService.print(document);
    }

    public boolean print(Printable painter) {
        if (this.printService == null) {
            this.printService = this.createPrintService();
        }
        return this.printService.print(painter);
    }

    public PageFormat showPageFormatDialog(PageFormat page) {
        if (this.printService == null) {
            this.printService = this.createPrintService();
        }
        return this.printService.showPageFormatDialog(page);
    }

    public InputStream readUserPreferences(String name) {
        if (this.basicService == null) {
            this.basicService = this.createBasicService();
        }
        if (this.persistenceService == null) {
            this.persistenceService = this.createPersistenceService();
        }
        try {
            URL fileURL = this.basicService.getCodeBase();
            FileContents file = this.persistenceService.get(fileURL);
            return file.getInputStream();
        }
        catch (Exception x) {
            return null;
        }
    }

    public OutputStream storeUserPreferences(String name) {
        if (this.basicService == null) {
            this.basicService = this.createBasicService();
        }
        if (this.persistenceService == null) {
            this.persistenceService = this.createPersistenceService();
        }
        try {
            URL codebase = this.basicService.getCodeBase();
            URL fileURL = new URL(codebase, name);
            try {
                FileContents file = this.persistenceService.get(fileURL);
                return file.getOutputStream(true);
            }
            catch (FileNotFoundException x) {
                long size = this.persistenceService.create(fileURL, 10000L);
                FileContents file = this.persistenceService.get(fileURL);
                return file.getOutputStream(false);
            }
        }
        catch (Exception x) {
            return null;
        }
    }

    public FileAccess openFileDialog(String key) {
        if (this.basicService == null) {
            this.basicService = this.createBasicService();
        }
        if (this.fileOpenService == null) {
            this.fileOpenService = this.createFileOpenService();
        }
        try {
            FileContents fc = this.fileOpenService.openFileDialog(null, null);
            if (fc == null) {
                return null;
            }
            return new JNLPFileAccess(fc);
        }
        catch (IOException x) {
            return null;
        }
    }

    public boolean isAvailable(String part) {
        if (this.basicService == null) {
            this.basicService = this.createBasicService();
        }
        if (this.downloadService == null) {
            this.downloadService = this.createDownloadService();
        }
        return this.downloadService.isPartCached(part);
    }

    public boolean makeAvailable(String part) {
        return this.makeAvailable(part, "Loading " + part);
    }

    public boolean makeAvailable(final String part, String message) {
        if (this.isAvailable(part)) {
            return true;
        }
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                final ProgressDialog progress = new ProgressDialog(message);
                final JDialog dlg = progress.createDialog(Application.getApplication(), "Downloading...");
                Thread t = new Thread(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            try {
                                JNLPServiceManager.this.downloadService.loadPart(part, (DownloadServiceListener)progress);
                            }
                            catch (IOException x) {
                                progress.setFailed();
                                Object var3_2 = null;
                                dlg.dispose();
                                return;
                            }
                            Object var3_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            dlg.dispose();
                            throw throwable;
                        }
                        dlg.dispose();
                    }
                };
                t.start();
                dlg.show();
                return progress.isDone();
            }
            this.downloadService.loadPart(part, this.downloadService.getDefaultProgressWindow());
            return true;
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
    }
}

