/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import org.freehep.application.HasPopupItems;
import org.freehep.swing.layout.ToolBarLayout;

public class ToolBarHolder
extends JPanel
implements HasPopupItems {
    private static final String nameKey = "nameKey";
    private static final String modeKey = "modekey";
    private Vector toolbars = new Vector();

    protected ToolBarHolder() {
        super(new ToolBarLayout(0, 5, 5));
    }

    void add(JToolBar bar, String name, int mode) {
        if (mode == 0) {
            mode = 2;
        }
        bar.putClientProperty(modeKey, new Integer(mode));
        bar.putClientProperty(nameKey, name);
        this.toolbars.add(bar);
        this.add(bar);
    }

    void remove(JToolBar bar) {
        this.toolbars.remove(bar);
        this.remove(bar);
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu popup, Component src) {
        int i = 0;
        while (i < this.getComponentCount()) {
            final JToolBar bar = (JToolBar)this.getComponent(i);
            String name = (String)bar.getClientProperty(nameKey);
            int mode = (Integer)bar.getClientProperty(modeKey);
            if (mode != 4) {
                JMenu menu = new JMenu(name);
                final JRadioButtonMenuItem show = new JRadioButtonMenuItem("Show");
                final JRadioButtonMenuItem hide = new JRadioButtonMenuItem("Hide");
                JRadioButtonMenuItem auto = new JRadioButtonMenuItem("Auto");
                show.setSelected(mode == 2);
                hide.setSelected(mode == 1);
                auto.setSelected(mode == 3);
                ActionListener al = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Object source = e.getSource();
                        if (source == hide) {
                            bar.putClientProperty(ToolBarHolder.modeKey, new Integer(1));
                            bar.setVisible(false);
                        } else if (source == show) {
                            bar.putClientProperty(ToolBarHolder.modeKey, new Integer(2));
                            bar.setVisible(true);
                        }
                    }
                };
                show.addActionListener(al);
                hide.addActionListener(al);
                auto.addActionListener(al);
                menu.add(show);
                menu.add(hide);
                menu.add(auto);
                popup.add(menu);
            }
            ++i;
        }
        return popup;
    }
}

