/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;

public abstract class PageManager {
    private CommandProcessor commandProcessor;
    protected EventListenerList listenerList;
    private List pages = new ArrayList();
    private PageContext selected;
    static /* synthetic */ Class class$org$freehep$application$mdi$PageListener;

    public PageContext openPage(Component c, String title, Icon icon) {
        PageContext context = new PageContext(c, title, icon);
        context.setPageManager(this);
        this.pages.add(context);
        if (c instanceof ManagedPage) {
            ((ManagedPage)((Object)c)).setPageContext(context);
        }
        this.firePageEvent(context, 4004);
        this.getCommandProcessor().setChanged();
        return context;
    }

    public boolean closeAll() {
        Iterator i = ((AbstractList)new ArrayList(this.pages)).iterator();
        while (i.hasNext()) {
            if (this.close((PageContext)i.next())) continue;
            return false;
        }
        return true;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public PageContext getSelectedPage() {
        return this.selected;
    }

    protected abstract void show(PageContext var1);

    protected boolean close(PageContext page) {
        if (page.getPage() instanceof ManagedPage && !((ManagedPage)((Object)page.getPage())).close()) {
            return false;
        }
        this.pages.remove(page);
        if (page == this.selected) {
            this.fireSelectionChanged(null);
        }
        this.firePageEvent(page, 4001);
        this.getCommandProcessor().setChanged();
        return true;
    }

    protected abstract void titleChanged(PageContext var1);

    protected abstract void iconChanged(PageContext var1);

    protected abstract Component getEmbodiment();

    protected CommandProcessor createCommandProcessor() {
        return new PageManagerCommandProcessor();
    }

    protected CommandProcessor getCommandProcessor() {
        if (this.commandProcessor == null) {
            this.commandProcessor = this.createCommandProcessor();
        }
        return this.commandProcessor;
    }

    public List pages() {
        return this.pages;
    }

    protected void init(List pages, PageContext selected) {
        this.pages = pages;
        this.selected = selected;
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            PageContext page = (PageContext)i.next();
            page.setPageManager(this);
        }
    }

    protected void fireSelectionChanged(PageContext context) {
        if (this.selected != null) {
            this.firePageEvent(this.selected, 4000);
        }
        this.selected = context;
        if (context != null) {
            this.firePageEvent(this.selected, 3999);
        }
        this.getCommandProcessor().setChanged();
    }

    protected void firePageEvent(PageContext context, int id) {
        PageEvent event = null;
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$org$freehep$application$mdi$PageListener == null ? PageManager.class$("org.freehep.application.mdi.PageListener") : class$org$freehep$application$mdi$PageListener)) {
                    if (event == null) {
                        event = new PageEvent(context, id);
                    }
                    ((PageListener)listeners[i + 1]).pageChanged(event);
                }
                i -= 2;
            }
        }
        context.firePageEvent(event, id);
    }

    public void addPageListener(PageListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$org$freehep$application$mdi$PageListener == null ? (class$org$freehep$application$mdi$PageListener = PageManager.class$("org.freehep.application.mdi.PageListener")) : class$org$freehep$application$mdi$PageListener, listener);
    }

    public void removePageListener(PageListener listener) {
        this.listenerList.remove(class$org$freehep$application$mdi$PageListener == null ? (class$org$freehep$application$mdi$PageListener = PageManager.class$("org.freehep.application.mdi.PageListener")) : class$org$freehep$application$mdi$PageListener, listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class PageManagerCommandProcessor
    extends CommandProcessor {
        public void onCloseAllPages() {
            PageManager.this.closeAll();
        }

        public void enableCloseAllPages(CommandState state) {
            state.setEnabled(PageManager.this.getPageCount() > 0);
        }

        public void onClosePage() {
            PageManager.this.close(PageManager.this.getSelectedPage());
        }

        public void enableClosePage(CommandState state) {
            state.setEnabled(PageManager.this.getSelectedPage() != null);
        }
    }
}

