/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.freehep.application.Stoppable;
import org.freehep.util.images.ImageHandler;

public class StatusBar
extends JPanel {
    private JLabel m_label = new JLabel();
    private JLabel m_stopButton;
    private JProgressBar m_meter = new JProgressBar();
    private Stoppable m_stop;

    public StatusBar() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(2, 5, 0));
        this.m_meter.setSize(250, 10);
        Icon icon = ImageHandler.getIcon("/toolbarButtonGraphics/general/Stop16.gif", this.getClass());
        this.m_stopButton = new JLabel(icon);
        this.m_stopButton.setEnabled(false);
        this.m_stopButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Stoppable stop = StatusBar.this.m_stop;
                if (stop != null) {
                    stop.stop();
                }
            }
        });
        p.add(this.m_meter);
        p.add(this.m_stopButton);
        this.add("East", p);
        this.add("Center", this.m_label);
    }

    public void setMessage(final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable run = new Runnable(){

                public void run() {
                    StatusBar.this.setMessage(message);
                }
            };
            SwingUtilities.invokeLater(run);
        } else if (message == null) {
            this.m_label.setText(" ");
        } else {
            this.m_label.setText(message);
        }
    }

    public void setModel(BoundedRangeModel model) {
        if (model == null) {
            this.m_meter.setModel(new DefaultBoundedRangeModel());
        } else {
            this.m_meter.setModel(model);
        }
    }

    public void setStoppable(Stoppable stop) {
        if (stop == null) {
            this.setModel(null);
            this.m_stopButton.disable();
            this.m_stopButton.repaint();
            this.m_stop = stop;
        } else {
            this.m_stop = stop;
            this.setModel(stop.getModel());
            this.m_stopButton.enable();
            this.m_stopButton.repaint();
        }
    }

    public BoundedRangeModel getModel() {
        return this.m_meter.getModel();
    }
}

