/*
 * Decompiled with CFR 0.152.
 */
package jas.util.moverlayeredpane;

import jas.util.moverlayeredpane.MLPHandle;
import jas.util.moverlayeredpane.MovableObjectBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class DefaultMOB
implements MovableObjectBorder {
    private Color lineColor;
    private int lineWidth;
    private int lineHeight;
    private int insetsFromRealBorder = 5;
    private Color handleColor;
    private int cornerHandleSideLength;
    private int sideHandleSideLength;
    private final int thickness = 6;
    private final int thick2 = 3;
    private MLPHandle[] handles = new MLPHandle[8];

    public DefaultMOB(Color lineColor, int lineWidth, int lineHeight, int insetsFromRealBorder, Color handleColor, int cornerHandleSideLength, int sideHandleSideLength) {
        this.lineColor = lineColor;
        this.lineWidth = lineWidth;
        this.lineHeight = lineHeight;
        this.insetsFromRealBorder = insetsFromRealBorder;
        this.handleColor = handleColor;
        this.cornerHandleSideLength = cornerHandleSideLength;
        this.sideHandleSideLength = sideHandleSideLength;
        int i = 0;
        while (i < this.handles.length) {
            this.handles[i] = new MLPHandle(6);
            ++i;
        }
    }

    public int getCursor(Component c, Point p) {
        Rectangle r = this.getRepaintRegion(c);
        MLPHandle[] h = this.getHandles(r.x, r.y, r.width, r.height);
        int i = 0;
        while (i < h.length) {
            if (h[i].contains(p)) {
                return h[i].getCursor();
            }
            ++i;
        }
        if (this.isPointOverTheBorder(c, p)) {
            return 13;
        }
        return 0;
    }

    public void paintBorder(Component c, Graphics g) {
        if (c == null) {
            return;
        }
        Color oldColor = g.getColor();
        Rectangle r = this.getRepaintRegion(c);
        MLPHandle[] theHandles = this.getHandles(r.x, r.y, r.width, r.height);
        g.setColor(this.lineColor);
        g.drawRect(r.x, r.y, r.width, r.height);
        int i = 0;
        while (i < theHandles.length) {
            g.fillRect(theHandles[i].x, theHandles[i].y, theHandles[i].width, theHandles[i].height);
            ++i;
        }
        g.setColor(oldColor);
    }

    public boolean isPointOverTheBorder(Component c, Point p) {
        int x = p.x;
        int y = p.y;
        if (c == null) {
            return false;
        }
        int extra = 3;
        Rectangle r = this.getRepaintRegion(c);
        if (x >= r.x - extra && x <= r.x + r.width + extra && y >= r.y - extra && y <= r.y + r.height + extra) {
            return x <= r.x + this.lineWidth || x >= r.x + r.width - this.lineWidth || y <= r.y + this.lineHeight || y >= r.y + r.height - this.lineHeight;
        }
        return false;
    }

    public Rectangle getRepaintRegion(Component c) {
        return this.getEquivalentBorderRectangle(new Rectangle(c.getLocation().x, c.getLocation().y, c.getSize().width, c.getSize().height));
    }

    private Rectangle getMinimumBorderRectangle(Component c) {
        return this.getEquivalentBorderRectangle(new Rectangle(c.getLocation().x, c.getLocation().y, c.getMinimumSize().width, c.getMinimumSize().height));
    }

    private MLPHandle[] getHandles(int xx, int yy, int ww, int hh) {
        this.handles[0].set(6, xx, yy);
        this.handles[1].set(7, xx + ww, yy);
        this.handles[2].set(5, xx + ww, yy + hh);
        this.handles[3].set(4, xx, yy + hh);
        this.handles[4].set(8, xx + ww / 2, yy);
        this.handles[5].set(9, xx + ww / 2, yy + hh);
        this.handles[6].set(10, xx, yy + hh / 2);
        this.handles[7].set(11, xx + ww, yy + hh / 2);
        return this.handles;
    }

    private Rectangle getEquivalentBorderRectangle(Rectangle r) {
        return new Rectangle(r.x - 4, r.y - 4, r.width + 6, r.height + 6);
    }
}

