/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.test.da;

import hep.analysis.EventSource;
import jas.jds.module.AnnotatedEventSource;
import jas.jds.module.LocalDIM;
import jas.jds.module.LocalJobBuilder;
import jas.jds.module.ModuleException;
import jas.tuple.test.JASTupleExplorer;
import jas.tuple.test.da.AbstractDIMAdapter;
import javax.swing.BoundedRangeModel;

class NTupleOpener
implements LocalJobBuilder {
    private JASTupleExplorer app;
    private AbstractDIMAdapter da;
    private LocalDIM dim;
    private boolean autoOpen = true;

    NTupleOpener(JASTupleExplorer app, AbstractDIMAdapter da) {
        this.app = app;
        this.da = da;
    }

    void setDIM(LocalDIM dim) {
        this.dim = dim;
    }

    public void createJob(String dataSource) {
        try {
            EventSource es = this.dim.openDataSet(dataSource);
            if (es != null) {
                this.setEventSource(es);
            }
        }
        catch (ModuleException x) {
            this.app.error("Cannot create job", x);
        }
    }

    public void setEventSource(EventSource eventSource) {
        this.da.createTuplesFromEventSource((AnnotatedEventSource)eventSource);
        if (this.autoOpen) {
            int i = 0;
            while (i < this.da.getNTuples()) {
                this.app.addTuple(this.da.getNTuple(i), this.da);
                ++i;
            }
        }
    }

    public void setMessage(String message) {
        this.app.setStatusMessage(message);
    }

    public void setProgressModel(BoundedRangeModel model) {
        this.app.getStatusBar().setModel(model);
    }

    public void clearProgressModel() {
        this.app.getStatusBar().setModel(null);
    }
}

