/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.test;

import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCut;
import jas.tuple.NTupleTableModel;
import jas.tuple.Plot;
import jas.tuple.Projection;
import jas.tuple.TreeTuple;
import jas.tuple.cut.AddCutDialog;
import jas.tuple.cut.CutDialog;
import jas.tuple.cut.CutSet;
import jas.tuple.jel.JELColumn;
import jas.tuple.jel.JELColumnProperties;
import jas.tuple.jel.NewColumnDialog;
import jas.tuple.project.Profile;
import jas.tuple.project.Project1D;
import jas.tuple.project.Project2D;
import jas.tuple.project.ProjectObject1D;
import jas.tuple.project.Scatter2D;
import jas.tuple.test.JASPlot;
import jas.tuple.test.JASTupleExplorer;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;

public class TupleCommands
extends CommandProcessor {
    private TreeTuple tuple;
    private JASTupleExplorer app;
    private List selected = new LinkedList();
    static /* synthetic */ Class class$java$awt$Frame;

    void addSelectedColumn(NTupleColumn col) {
        this.selected.add(col);
        this.setChanged();
    }

    void removeSelectedColumn(NTupleColumn col) {
        this.selected.remove(col);
        this.setChanged();
    }

    TupleCommands(JASTupleExplorer app, TreeTuple tuple) {
        this.app = app;
        this.tuple = tuple;
    }

    public void onClose() {
        this.app.removeTuple(this.tuple);
    }

    public void onTabulate() {
        NTupleTableModel model = new NTupleTableModel(this.tuple.getNTuple());
        JTable table = new JTable(model);
        this.app.getPageManager().openPage((Component)new JScrollPane(table), this.tuple.getNTuple().getTitle(), null);
    }

    public void onTabulateSelected() {
        NTupleTableModel model = new NTupleTableModel(this.tuple.getNTuple(), new ArrayList(this.selected));
        JTable table = new JTable(model);
        this.app.getPageManager().openPage((Component)new JScrollPane(table), this.tuple.getNTuple().getTitle(), null);
    }

    public void enableTabulateSelected(CommandState state) {
        state.setEnabled(!this.selected.isEmpty());
    }

    public void onHistogram() {
        if (this.selected.size() == 1) {
            NTupleColumn col = (NTupleColumn)this.selected.get(0);
            Observable project = col.getType().isPrimitive() ? new Project1D(col) : new ProjectObject1D(col);
            Plot plot = this.app.createPlot(this.tuple, (Projection)((Object)project));
            this.app.getPageManager().openPage((Component)((Object)new JASPlot(plot)), "Plot: " + plot.getName(), null);
        } else {
            NTupleColumn colx = (NTupleColumn)this.selected.get(0);
            NTupleColumn coly = (NTupleColumn)this.selected.get(1);
            Project2D project = new Project2D(colx, coly);
            Plot plot = this.app.createPlot(this.tuple, project);
            this.app.getPageManager().openPage((Component)((Object)new JASPlot(plot)), "Plot: " + plot.getName(), null);
        }
    }

    public void enableHistogram(CommandState state) {
        state.setEnabled(this.selected.size() == 1 || this.selected.size() == 2);
    }

    public void onScatterPlot() {
        NTupleColumn colx = (NTupleColumn)this.selected.get(0);
        NTupleColumn coly = (NTupleColumn)this.selected.get(1);
        Scatter2D project = new Scatter2D(colx, coly);
        Plot plot = this.app.createPlot(this.tuple, project);
        this.app.getPageManager().openPage((Component)((Object)new JASPlot(plot)), "Plot: " + plot.getName(), null);
    }

    public void enableScatterPlot(CommandState state) {
        state.setEnabled(this.selected.size() == 2);
    }

    public void onProfilePlot() {
        NTupleColumn colx = (NTupleColumn)this.selected.get(0);
        NTupleColumn coly = (NTupleColumn)this.selected.get(1);
        Profile project = new Profile(colx, coly);
        Plot plot = this.app.createPlot(this.tuple, project);
        this.app.getPageManager().openPage((Component)((Object)new JASPlot(plot)), "Plot: " + plot.getName(), null);
    }

    public void enableProfilePlot(CommandState state) {
        state.setEnabled(this.selected.size() == 2);
    }

    public void onCutProperties() {
        CutSet cs = this.tuple.defaultCuts();
        CutDialog.show((Component)((Object)this.app), cs, this.tuple);
    }

    public void onAddCut() {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = TupleCommands.class$("java.awt.Frame")) : class$java$awt$Frame, (Component)((Object)this.app));
        AddCutDialog dlg = new AddCutDialog(frame, this.tuple);
        dlg.pack();
        dlg.setLocationRelativeTo((Component)((Object)this.app));
        dlg.show();
        NTupleCut cut = dlg.getCut();
        if (cut != null) {
            this.tuple.defaultCuts().addCut(cut);
        }
    }

    public void onAddColumn() {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = TupleCommands.class$("java.awt.Frame")) : class$java$awt$Frame, (Component)((Object)this.app));
        NewColumnDialog dlg = new NewColumnDialog(frame, this.tuple.getNTuple());
        dlg.pack();
        dlg.setLocationRelativeTo((Component)((Object)this.app));
        dlg.show();
    }

    public void onColumnProperties() {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = TupleCommands.class$("java.awt.Frame")) : class$java$awt$Frame, (Component)((Object)this.app));
        JELColumn column = (JELColumn)this.selected.get(0);
        JELColumnProperties dlg = new JELColumnProperties(frame, column, this.tuple.getNTuple());
        dlg.pack();
        dlg.setLocationRelativeTo((Component)((Object)this.app));
        dlg.show();
    }

    public void enableColumnProperties(CommandState state) {
        state.setEnabled(this.selected.size() == 1 && this.selected.get(0) instanceof JELColumn);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

