/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.test;

import jas.tuple.Plot;
import jas.tuple.test.ComponentDataFlavor;
import jas.tuple.test.JASPlot;
import jas.tuple.test.PlotDataFlavor;
import jas.tuple.test.XMLIO;
import jas.util.moverlayeredpane.MoverLayeredPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdom.Element;

class Page
extends MoverLayeredPane
implements DropTargetListener,
Printable {
    private DataFlavor df = new ComponentDataFlavor();
    private DataFlavor pf = new PlotDataFlavor();

    Page() {
        this.setPreferredSize(new Dimension(400, 600));
        this.setMinimumSize(new Dimension(20, 20));
        this.getContentPanel().setBackground(Color.white);
        DropTarget dropTarget = new DropTarget(this.getBorderPanel(), this);
    }

    Element save() {
        Element page = new Element("Page");
        JComponent contents = this.getContentPanel();
        int i = 0;
        while (i < contents.countComponents()) {
            Component c = contents.getComponent(i);
            if (c instanceof XMLIO) {
                Element e = new Element("Component");
                e.setAttribute("x", String.valueOf(c.getX()));
                e.setAttribute("y", String.valueOf(c.getY()));
                e.setAttribute("width", String.valueOf(c.getWidth()));
                e.setAttribute("height", String.valueOf(c.getHeight()));
                page.addContent(e);
                e.addContent(((XMLIO)((Object)c)).save());
            }
            ++i;
        }
        return page;
    }

    void open(Element e) {
        Iterator i = e.getChildren("Component").iterator();
        while (i.hasNext()) {
            Element component = (Element)i.next();
            int x = Integer.parseInt(component.getAttributeValue("x"));
            int y = Integer.parseInt(component.getAttributeValue("y"));
            int width = Integer.parseInt(component.getAttributeValue("width"));
            int height = Integer.parseInt(component.getAttributeValue("height"));
            Component c = null;
            this.getContentPanel().add(c);
            c.setBounds(x, y, width, height);
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragEnter(DropTargetDragEvent e) {
        this.acceptOrReject(e);
    }

    public void dragOver(DropTargetDragEvent e) {
        this.acceptOrReject(e);
    }

    private void acceptOrReject(DropTargetDragEvent e) {
        Component c = this.getContentPanel().getComponentAt(e.getLocation());
        if (c instanceof JASPlot && e.isDataFlavorSupported(this.pf)) {
            e.acceptDrag(0x40000000);
        } else if (e.isDataFlavorSupported(this.df) || e.isDataFlavorSupported(this.pf)) {
            e.acceptDrag(0x40000000);
        } else {
            e.rejectDrag();
        }
    }

    public void drop(DropTargetDropEvent e) {
        try {
            Component target = this.getContentPanel().getComponentAt(e.getLocation());
            Transferable t = e.getTransferable();
            if (target instanceof JASPlot && t.isDataFlavorSupported(this.pf)) {
                e.acceptDrop(0x40000000);
                Plot p = (Plot)t.getTransferData(this.pf);
                ((JASPlot)((Object)target)).addData(p.getProjection().getDataSource()).show(true);
                e.dropComplete(true);
            } else if (t.isDataFlavorSupported(this.df)) {
                e.acceptDrop(0x40000000);
                JComponent c = (JComponent)t.getTransferData(this.df);
                c.setBorder(BorderFactory.createLineBorder(Color.black));
                this.getContentPanel().add(c);
                Point l = e.getLocation();
                Dimension size = c.getPreferredSize();
                l.translate(-size.width / 2, -size.height / 2);
                c.setBounds(l.x, l.y, size.width, size.height);
                c.validate();
                e.dropComplete(true);
            } else if (t.isDataFlavorSupported(this.pf)) {
                e.acceptDrop(0x40000000);
                Plot p = (Plot)t.getTransferData(this.pf);
                JASPlot c = new JASPlot(p);
                c.setTitle(p.getName());
                ((JComponent)((Object)c)).setBorder(BorderFactory.createLineBorder(Color.black));
                this.getContentPanel().add((Component)((Object)c));
                Point l = e.getLocation();
                Dimension size = ((JComponent)((Object)c)).getPreferredSize();
                l.translate(-size.width / 2, -size.height / 2);
                ((Component)((Object)c)).setBounds(l.x, l.y, size.width, size.height);
                ((Container)((Object)c)).validate();
                e.dropComplete(true);
            } else {
                e.rejectDrop();
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
            e.dropComplete(false);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public int print(Graphics graphics, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        this.print(g2);
        return 0;
    }
}

