/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.test;

import jas.tuple.CutColumn;
import jas.tuple.MutableNTuple;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCut;
import jas.tuple.NTupleTreeCellRenderer;
import jas.tuple.NTupleTreeModel;
import jas.tuple.Plot;
import jas.tuple.Projection;
import jas.tuple.TreeTuple;
import jas.tuple.cut.CutDialog;
import jas.tuple.cut.CutSet;
import jas.tuple.cut.NumericCut1D;
import jas.tuple.jel.JELColumn;
import jas.tuple.jel.JELCut;
import jas.tuple.project.Project1D;
import jas.tuple.project.ProjectObject1D;
import jas.tuple.test.AllSupportedFileFilter;
import jas.tuple.test.DIMAdapter;
import jas.tuple.test.DIMFactory;
import jas.tuple.test.DIMRegistry;
import jas.tuple.test.DnDTree;
import jas.tuple.test.JASPlot;
import jas.tuple.test.Page;
import jas.tuple.test.TupleCommands;
import jas.tuple.test.da.FlatFileDIMFactory;
import jas.tuple.test.da.JDBCDIMFactory;
import jas.tuple.test.da.PAWDIMFactory;
import jas.tuple.test.da.RootDIMFactory;
import jas.util.UserProperties;
import jasext.hist.Register;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import org.freehep.application.PrintPreview;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.mdi.MDIApplication;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.mdi.TabbedPageManager;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class JASTupleExplorer
extends MDIApplication {
    private NTupleTreeModel tm = new NTupleTreeModel();
    private JTree tree;
    private int nPages = 0;

    public JASTupleExplorer() throws Exception {
        super("JASTupleExplorer");
        UIManager.installLookAndFeel("Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel");
        this.createUserProperties();
        DIMRegistry.registerDIM(new PAWDIMFactory());
        DIMRegistry.registerDIM(new JDBCDIMFactory());
        DIMRegistry.registerDIM(new FlatFileDIMFactory());
        DIMRegistry.registerDIM(new RootDIMFactory());
        new Register().init();
        this.tree = new DnDTree(this.tm);
        this.tree.setCellRenderer(new NTupleTreeCellRenderer());
        this.tree.setRootVisible(false);
        this.getControlManager().openPage((Component)new JScrollPane(this.tree), "Tree", null);
        this.tree.addTreeSelectionListener(new ColumnSelection());
        this.onNewPage();
        MouseAdapter doubleClick = new MouseAdapter(){
            static /* synthetic */ Class class$java$util$Date;

            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (e.getClickCount() == 2 && (path = JASTupleExplorer.this.tree.getPathForLocation(e.getX(), e.getY())) != null) {
                    Object node = path.getLastPathComponent();
                    if (node instanceof CutColumn) {
                        TreeTuple tuple = (TreeTuple)path.getPathComponent(path.getPathCount() - 2);
                        NTupleCut cut = ((CutColumn)node).getCut();
                        CutDialog.show((Component)((Object)JASTupleExplorer.this), cut, tuple);
                    } else if (node instanceof NTupleColumn) {
                        TreeTuple tuple = (TreeTuple)path.getPathComponent(path.getPathCount() - 2);
                        NTupleColumn col = (NTupleColumn)node;
                        Observable project = col.getType().isPrimitive() ? new Project1D(col) : ((class$java$util$Date == null ? (class$java$util$Date = 1.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(col.getType()) ? new Project1D(col) : new ProjectObject1D(col));
                        Plot plot = JASTupleExplorer.this.createPlot(tuple, (Projection)((Object)project));
                        JASTupleExplorer.this.getPageManager().openPage((Component)((Object)new JASPlot(plot)), "Plot: " + plot.getName(), null);
                    }
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        this.tree.addMouseListener(doubleClick);
    }

    public void init() {
        this.setStatusMessage("Restoring settings");
        try {
            SAXBuilder builder = new SAXBuilder();
            String dir = System.getProperty("user.home");
            File f = new File(new File(dir), "jte.xml");
            Document doc = builder.build(f);
            Element root = doc.getRootElement();
            ArrayList<DIMAdapter> dims = new ArrayList<DIMAdapter>();
            Iterator i = root.getChildren("DataSource").iterator();
            while (i.hasNext()) {
                try {
                    Element e = (Element)i.next();
                    String dimName = e.getAttributeValue("dim");
                    DIMFactory df = (DIMFactory)Class.forName(dimName).newInstance();
                    DIMAdapter dim = df.create();
                    Element param = e.getChild("param");
                    dim.open(param);
                    dims.add(dim);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            Iterator i2 = root.getChildren("NTuple").iterator();
            block6: while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String name = e.getAttributeValue("name");
                Iterator k = dims.iterator();
                while (k.hasNext()) {
                    DIMAdapter dim = (DIMAdapter)k.next();
                    MutableNTuple tuple = dim.getNTuple(name);
                    if (tuple == null) continue;
                    TreeTuple tt = this.addTuple(tuple, dim);
                    Iterator j = e.getChildren().iterator();
                    while (j.hasNext()) {
                        Element cut;
                        Element col = (Element)j.next();
                        if (col.getName().equals("Column")) {
                            String colName = col.getAttributeValue("name");
                            Element exp = col.getChild("Expression");
                            String value = exp.getAttributeValue("value");
                            tuple.addColumn(new JELColumn(tuple, colName, value));
                            continue;
                        }
                        if (!col.getName().equals("Cut")) continue;
                        String cutName = col.getAttributeValue("name");
                        String cutType = col.getAttributeValue("type");
                        if (cutType.equals("Numeric1D")) {
                            cut = col.getChild("Numeric1D");
                            int type = Integer.parseInt(cut.getAttributeValue("type"));
                            String colName = cut.getAttributeValue("column");
                            NTupleColumn column = tuple.getColumnByName(colName);
                            String exp = cut.getAttributeValue("expression");
                            NumericCut1D newCut = new NumericCut1D(cutName, column, type);
                            tt.addCut(newCut);
                            tt.defaultCuts().addCut(newCut);
                            continue;
                        }
                        cut = col.getChild("Expression");
                        String value = cut.getAttributeValue("value");
                        JELCut newCut = new JELCut(cutName, tuple, value);
                        tt.addCut(newCut);
                        tt.defaultCuts().addCut(newCut);
                    }
                    continue block6;
                }
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void openFile(File f) {
        Enumeration e = DIMRegistry.elements();
        while (e.hasMoreElements()) {
            DIMFactory dim = (DIMFactory)e.nextElement();
            FileFilter ff = dim.getFileFilter();
            if (ff == null || !ff.accept(f)) continue;
            this.openDataSet(f, dim.create());
            return;
        }
        this.error("Unrecognized file type");
    }

    private void openDataSet(File f, DIMAdapter dim) {
        try {
            dim.openFile(f);
        }
        catch (IOException x) {
            this.error("Error opening " + f, x);
        }
    }

    public TreeTuple addTuple(MutableNTuple tuple, DIMAdapter dim) {
        DIMTuple tt = new DIMTuple(tuple, dim);
        this.tm.add(tt);
        return tt;
    }

    public void removeTuple(TreeTuple tuple) {
        this.tm.remove(tuple);
    }

    Plot createPlot(final TreeTuple tuple, Projection proj) {
        CutSet cs = new CutSet("");
        cs.addCut(tuple.defaultCuts());
        final Plot plot = new Plot(proj.getDataSource().getTitle(), proj, cs, tuple);
        Runnable run = new Runnable(){

            public void run() {
                plot.invalidate();
                tuple.run();
            }
        };
        proj.setRunnable(run);
        tuple.plots().add(plot);
        tuple.run();
        return plot;
    }

    public static void main(String[] args) throws Exception {
        new JASTupleExplorer().createFrame(args).show();
    }

    protected Properties createUserProperties() {
        return new TranslatedUserProperties(this.getAppProperties());
    }

    public void onPrintPreview() {
        PrintPreview pp = this.createPrintPreview();
        pp.setPageable((Pageable)new TuplePageable());
        this.showDialog(pp.createDialog((Component)((Object)this)), "PrintPreview");
    }

    public void enablePrintPreview(CommandState state) {
        state.setEnabled(new TuplePageable().getNumberOfPages() > 0);
    }

    public void onPrint() {
        this.getServiceManager().print((Pageable)new TuplePageable());
    }

    public void enablePrint(CommandState state) {
        state.setEnabled(new TuplePageable().getNumberOfPages() > 0);
    }

    public void onNewPage() {
        this.getPageManager().openPage((Component)new Page(), "Page " + ++this.nPages, null);
        this.getCommandProcessor().setChanged();
    }

    public void onOpenData() {
        JFileChooser dlg = new JFileChooser(this.getUserProperties().getProperty("lastDataFile", System.getProperty("user.home")));
        dlg.setDialogTitle("Open File...");
        AllSupportedFileFilter all = new AllSupportedFileFilter();
        Enumeration e = DIMRegistry.elements();
        while (e.hasMoreElements()) {
            DIMFactory dim = (DIMFactory)e.nextElement();
            FileFilter ff = dim.getFileFilter();
            if (ff == null) continue;
            all.add(ff);
            dlg.addChoosableFileFilter(ff);
        }
        dlg.setFileFilter(all);
        if (dlg.showOpenDialog((Component)((Object)this)) == 0) {
            File f = dlg.getSelectedFile();
            this.getUserProperties().setProperty("lastDataFile", f.getParent());
            this.openFile(f);
        }
    }

    protected PageManager createPageManager() {
        return new TabbedPageManager();
    }

    protected void exit() {
        int rc = JOptionPane.showConfirmDialog((Component)((Object)this), "Save Changes?");
        if (rc == 2) {
            return;
        }
        if (rc == 0) {
            this.onSave();
        }
        super.exit();
    }

    public void onSave() {
        HashSet<DIMAdapter> s = new HashSet<DIMAdapter>();
        Element rootElement = new Element("JASTupleExplorer");
        Object root = this.tm.getRoot();
        int i = 0;
        while (i < this.tm.getChildCount(root)) {
            DIMTuple tt = (DIMTuple)this.tm.getChild(root, i);
            DIMAdapter dim = tt.getDIM();
            if (!s.contains(dim)) {
                s.add(dim);
                rootElement.addContent(dim.save());
            }
            MutableNTuple tuple = tt.getNTuple();
            Element tupleElement = new Element("NTuple");
            tupleElement.setAttribute("name", tuple.getTitle());
            rootElement.addContent(tupleElement);
            int j = 0;
            while (j < tuple.getNColumns()) {
                NTupleColumn col = tuple.getColumn(j);
                if (col instanceof JELColumn) {
                    Element expElement = new Element("Column");
                    expElement.setAttribute("name", col.getName());
                    expElement.setAttribute("type", "Expression");
                    Element exp = new Element("Expression");
                    exp.setAttribute("value", ((JELColumn)col).getExpression());
                    expElement.addContent(exp);
                    tupleElement.addContent(expElement);
                } else if (col instanceof CutColumn) {
                    Element cutElement = new Element("Cut");
                    cutElement.setAttribute("name", col.getName());
                    NTupleCut cut = ((CutColumn)col).getCut();
                    if (cut instanceof NumericCut1D) {
                        cutElement.setAttribute("type", "Numeric1D");
                        Element n = new Element("Numeric1D");
                        n.setAttribute("type", "2");
                        n.setAttribute("column", ((NumericCut1D)cut).getColumn().getName());
                        cutElement.addContent(n);
                    } else if (cut instanceof JELCut) {
                        cutElement.setAttribute("type", "Expression");
                        Element exp = new Element("Expression");
                        exp.setAttribute("value", ((JELCut)cut).getExpression());
                        cutElement.addContent(exp);
                    }
                    tupleElement.addContent(cutElement);
                }
                ++j;
            }
            ++i;
        }
        Document myDocument = new Document(rootElement);
        try {
            XMLOutputter outputter = new XMLOutputter("  ", true);
            String dir = System.getProperty("user.home");
            File f = new File(new File(dir), "jte.xml");
            outputter.output(myDocument, (Writer)new BufferedWriter(new FileWriter(f)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class TuplePageable
    implements Pageable {
        private List printables = new ArrayList();
        private Printable thePP = new PP();

        TuplePageable() {
            List pages = JASTupleExplorer.this.getPageManager().pages();
            Iterator i = pages.iterator();
            while (i.hasNext()) {
                PageContext pc = (PageContext)i.next();
                Component page = pc.getPage();
                if (!(page instanceof Printable)) continue;
                this.printables.add(page);
            }
        }

        public PageFormat getPageFormat(int page) throws IndexOutOfBoundsException {
            return JASTupleExplorer.this.getServiceManager().getDefaultPage();
        }

        public int getNumberOfPages() {
            return this.printables.size();
        }

        public Printable getPrintable(int page) throws IndexOutOfBoundsException {
            return this.thePP;
        }

        private class PP
        implements Printable {
            private PP() {
            }

            public int print(Graphics graphics, PageFormat pageFormat, int page) throws PrinterException {
                if (page > TuplePageable.this.printables.size()) {
                    return 1;
                }
                Printable p = (Printable)TuplePageable.this.printables.get(page);
                return p.print(graphics, pageFormat, 0);
            }
        }
    }

    private class ColumnSelection
    implements TreeSelectionListener {
        private TupleCommands commands;
        private TreeTuple current;

        private ColumnSelection() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] paths = treeSelectionEvent.getPaths();
            int i = 0;
            while (i < paths.length) {
                Object node;
                TreeTuple tt = (TreeTuple)paths[i].getPathComponent(1);
                if (tt != this.current && treeSelectionEvent.isAddedPath(i)) {
                    if (this.commands != null) {
                        JASTupleExplorer.this.getCommandTargetManager().remove((CommandProcessor)this.commands);
                    }
                    this.current = tt;
                    this.commands = new TupleCommands(JASTupleExplorer.this, tt);
                    JASTupleExplorer.this.getCommandTargetManager().add((CommandProcessor)this.commands);
                }
                if ((node = paths[i].getLastPathComponent()) instanceof NTupleColumn) {
                    if (treeSelectionEvent.isAddedPath(i)) {
                        this.commands.addSelectedColumn((NTupleColumn)paths[i].getLastPathComponent());
                    } else {
                        this.commands.removeSelectedColumn((NTupleColumn)paths[i].getLastPathComponent());
                    }
                }
                ++i;
            }
        }
    }

    private class DIMTuple
    extends TreeTuple {
        private DIMAdapter dim;

        DIMTuple(MutableNTuple tuple, DIMAdapter dim) {
            super(tuple);
            this.dim = dim;
        }

        DIMAdapter getDIM() {
            return this.dim;
        }
    }

    private class TranslatedUserProperties
    extends UserProperties {
        TranslatedUserProperties(Properties def) {
            super(def);
        }

        public String getProperty(String key) {
            return PropertyUtilities.translate((Properties)((Object)this), (String)super.getProperty(key));
        }

        public String getProperty(String key, String def) {
            return PropertyUtilities.translate((Properties)((Object)this), (String)super.getProperty(key, def));
        }
    }
}

