/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.test;

import jas.tuple.CutColumn;
import jas.tuple.NTupleColumn;
import jas.tuple.TreeTuple;
import jas.tuple.test.ColumnTransferable;
import jas.tuple.test.CutTransferable;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DnDTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    private DragSource dragSource = DragSource.getDefaultDragSource();
    private DragSourceContext dragSourceContext = null;
    private Point cursorLocation = null;

    public DnDTree(TreeModel model) {
        super(model);
        DragGestureRecognizer dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 0x40000000, this);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        TreePath path = this.getLeadSelectionPath();
        if (path.getLastPathComponent() instanceof CutColumn) {
            CutColumn col = (CutColumn)path.getLastPathComponent();
            TreeTuple tt = (TreeTuple)path.getPathComponent(1);
            CutTransferable transferable = new CutTransferable(col, tt);
            Cursor cursor = DragSource.DefaultLinkNoDrop;
            this.dragSource.startDrag(e, cursor, transferable, this);
        } else if (path.getLastPathComponent() instanceof NTupleColumn) {
            NTupleColumn col = (NTupleColumn)path.getLastPathComponent();
            TreeTuple tt = (TreeTuple)path.getPathComponent(1);
            ColumnTransferable transferable = new ColumnTransferable(col, tt);
            Cursor cursor = DragSource.DefaultLinkNoDrop;
            this.dragSource.startDrag(e, cursor, transferable, this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DragSource.DefaultLinkDrop);
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dsde) {
        dsde.getDragSourceContext().setCursor(DragSource.DefaultLinkNoDrop);
    }

    private void setCursor(DragSourceDragEvent dsde) {
        if (this.cursorLocation == null) {
            return;
        }
        TreePath destinationPath = this.getPathForLocation(this.cursorLocation.x, this.cursorLocation.y);
        DragSourceContext dsc = dsde.getDragSourceContext();
        dsc.setCursor(DragSource.DefaultCopyNoDrop);
    }
}

