/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.project;

import jas.hist.DataSource;
import jas.hist.HistogramUpdate;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.Projection;
import java.util.Observable;

public class Scatter2D
extends Observable
implements ScatterPlotSource,
Projection {
    private NTupleColumn colx;
    private NTupleColumn coly;
    private double minx = Double.NaN;
    private double maxx = Double.NaN;
    private double miny = Double.NaN;
    private double maxy = Double.NaN;
    private double[] x;
    private double[] y;
    private double[] xPoints;
    private double[] yPoints;
    private int n;
    private int nPoints;
    private static final HistogramUpdate hu = new HistogramUpdate(2, true);

    public Scatter2D(NTupleColumn x, NTupleColumn y) {
        this.colx = x;
        this.coly = y;
        this.minx = this.colx.getMinValue().getDouble();
        this.maxx = this.colx.getMaxValue().getDouble();
        this.miny = this.coly.getMinValue().getDouble();
        this.maxy = this.coly.getMaxValue().getDouble();
    }

    public void setRunnable(Runnable run) {
    }

    public DataSource getDataSource() {
        return this;
    }

    public void start() {
        this.x = new double[1000];
        this.y = new double[1000];
        this.n = 0;
    }

    public void fill(NTupleCursor cursor) {
        if (this.n == this.x.length) {
            double[] xNew = new double[this.n * 2];
            double[] yNew = new double[this.n * 2];
            System.arraycopy(this.x, 0, xNew, 0, this.n);
            System.arraycopy(this.y, 0, yNew, 0, this.n);
            this.x = xNew;
            this.y = yNew;
        }
        this.x[this.n] = this.colx.getValue(cursor).getDouble();
        this.y[this.n] = this.coly.getValue(cursor).getDouble();
        ++this.n;
    }

    public void end() {
        this.xPoints = this.x;
        this.yPoints = this.y;
        this.nPoints = this.n;
        this.setChanged();
        this.notifyObservers(hu);
    }

    public ScatterEnumeration startEnumeration(double param, double param1, double param2, double param3) {
        return this.startEnumeration();
    }

    public ScatterEnumeration startEnumeration() {
        return new Scatter2DEnumeration(this.xPoints, this.yPoints, this.nPoints);
    }

    public int getXAxisType() {
        return 1;
    }

    public int getYAxisType() {
        return 1;
    }

    public String getTitle() {
        return this.coly.getName() + " vs " + this.colx.getName();
    }

    public double getXMax() {
        return this.maxx;
    }

    public double getYMax() {
        return this.maxy;
    }

    public double getXMin() {
        return this.minx;
    }

    public double getYMin() {
        return this.miny;
    }

    private static class Scatter2DEnumeration
    implements ScatterEnumeration {
        private double[] x;
        private double[] y;
        private int n;
        private int i;

        Scatter2DEnumeration(double[] x, double[] y, int n) {
            this.x = x;
            this.y = y;
            this.n = n;
        }

        public boolean getNextPoint(double[] point) {
            if (this.i == this.n) {
                return false;
            }
            point[0] = this.x[this.i];
            point[1] = this.y[this.i];
            ++this.i;
            return true;
        }

        public void resetEndPoint() {
        }

        public void restart() {
            this.i = 0;
        }
    }
}

