/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.project;

import jas.hist.DataSource;
import jas.hist.HistogramUpdate;
import jas.hist.Rebinnable1DHistogramData;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.Projection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;

public class ProjectObject1D
extends Observable
implements Rebinnable1DHistogramData,
Projection {
    private NTupleColumn col;
    private String[] labels;
    private double[] counts;
    private HashMap map;
    private static final HistogramUpdate hu = new HistogramUpdate(2, true);

    public ProjectObject1D(NTupleColumn col) {
        this.col = col;
    }

    public int getBins() {
        return this.labels.length;
    }

    public int getAxisType() {
        return 2;
    }

    public double getMax() {
        return this.labels.length;
    }

    public double getMin() {
        return 0.0;
    }

    public String getTitle() {
        return this.col.getName();
    }

    public String[] getAxisLabels() {
        return this.labels;
    }

    public double[][] rebin(int bins, double min, double max, boolean param3, boolean param4) {
        return new double[][]{this.counts};
    }

    public boolean isRebinnable() {
        return false;
    }

    public void setRunnable(Runnable run) {
    }

    public DataSource getDataSource() {
        return this;
    }

    public void start() {
        this.map = new HashMap();
    }

    public void fill(NTupleCursor cursor) {
        Object o = this.col.getValue(cursor).getObject();
        Count count = (Count)this.map.get(o);
        if (count != null) {
            count.increment();
        } else {
            this.map.put(o, new Count(1));
        }
    }

    public void end() {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Count c1 = (Count)ProjectObject1D.this.map.get(o1);
                Count c2 = (Count)ProjectObject1D.this.map.get(o2);
                return c2.getValue() - c1.getValue();
            }
        };
        LinkedList keys = new LinkedList(this.map.keySet());
        Collections.sort(keys, c);
        int n = keys.size();
        if (n > 20) {
            n = 20;
        }
        this.labels = new String[n];
        this.counts = new double[n];
        int i = 0;
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (i < n) {
                String string = this.labels[i] = o == null ? "null" : o.toString();
                if (this.labels[i].length() > 10) {
                    this.labels[i] = this.labels[i].substring(0, 6) + "...";
                }
                this.counts[i] = ((Count)this.map.get(o)).getValue();
            } else {
                this.labels[n - 1] = "Other";
                int n2 = n - 1;
                this.counts[n2] = this.counts[n2] + (double)((Count)this.map.get(o)).getValue();
            }
            ++i;
        }
        this.map = null;
        this.setChanged();
        this.notifyObservers(hu);
    }

    private class Count {
        private int i;

        Count(int i) {
            this.i = i;
        }

        void increment() {
            ++this.i;
        }

        int getValue() {
            return this.i;
        }
    }
}

