/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.project;

import jas.hist.DataSource;
import jas.hist.HistogramUpdate;
import jas.hist.Rebinnable2DHistogramData;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.Projection;
import java.util.Observable;

public class Project2D
extends Observable
implements Rebinnable2DHistogramData,
Projection {
    private Runnable run;
    private NTupleColumn colx;
    private NTupleColumn coly;
    private int binsx = 40;
    private int binsy = 40;
    private double binWidthX;
    private double binWidthY;
    private double minx = Double.NaN;
    private double maxx = Double.NaN;
    private double miny = Double.NaN;
    private double maxy = Double.NaN;
    private double[][] data;
    private double[][] newData;
    private static final HistogramUpdate hu = new HistogramUpdate(2, true);

    public Project2D(NTupleColumn x, NTupleColumn y) {
        this.colx = x;
        this.coly = y;
        this.minx = this.colx.getMinValue().getDouble();
        this.maxx = this.colx.getMaxValue().getDouble();
        this.miny = this.coly.getMinValue().getDouble();
        this.maxy = this.coly.getMaxValue().getDouble();
    }

    public int getXAxisType() {
        return 1;
    }

    public int getYAxisType() {
        return 1;
    }

    public String[] getXAxisLabels() {
        return null;
    }

    public String[] getYAxisLabels() {
        return null;
    }

    public int getYBins() {
        return this.binsx;
    }

    public int getXBins() {
        return this.binsy;
    }

    public double getYMin() {
        return this.miny;
    }

    public double getXMin() {
        return this.minx;
    }

    public double getYMax() {
        return this.maxy;
    }

    public double getXMax() {
        return this.maxx;
    }

    public String getTitle() {
        return this.coly.getName() + " vs " + this.colx.getName();
    }

    public double[][][] rebin(int xBins, double xMin, double xMax, int yBins, double yMin, double yMax, boolean param6, boolean param7, boolean param8) {
        return new double[][][]{this.data};
    }

    public boolean isRebinnable() {
        return true;
    }

    public void setRunnable(Runnable run) {
        this.run = run;
    }

    public DataSource getDataSource() {
        return this;
    }

    public void start() {
        this.binWidthX = (this.maxx - this.minx) / (double)this.binsx;
        this.binWidthY = (this.maxy - this.miny) / (double)this.binsy;
        this.newData = new double[this.binsx][this.binsy];
    }

    public void fill(NTupleCursor cursor) {
        double x = this.colx.getValue(cursor).getDouble() - this.minx;
        if (x < 0.0) {
            return;
        }
        int xBin = (int)Math.floor(x / this.binWidthX);
        if (xBin >= this.binsx) {
            return;
        }
        double y = this.coly.getValue(cursor).getDouble() - this.miny;
        if (y < 0.0) {
            return;
        }
        int yBin = (int)Math.floor(y / this.binWidthY);
        if (yBin >= this.binsy) {
            return;
        }
        double[] dArray = this.newData[xBin];
        int n = yBin;
        dArray[n] = dArray[n] + 1.0;
    }

    public void end() {
        this.data = this.newData;
        this.setChanged();
        this.notifyObservers(hu);
    }
}

