/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.project;

import jas.hist.DataSource;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.Projection;
import java.util.Date;
import java.util.Observable;

public class Profile
extends Observable
implements Rebinnable1DHistogramData,
Projection,
HasStyle {
    private NTupleColumn col;
    private NTupleColumn colW;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private int bins = 50;
    private double binWidth;
    private double[] data;
    private double[] dataErrors;
    private double[] n;
    private double[] hist;
    private double[] error;
    private Runnable run;
    private JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
    private int type;
    private static final HistogramUpdate hu = new HistogramUpdate(2, true);
    static /* synthetic */ Class class$java$util$Date;

    public Profile(NTupleColumn col, NTupleColumn colW) {
        this.col = col;
        this.colW = colW;
        this.style.setShowHistogramBars(false);
        this.style.setShowDataPoints(true);
        if (col.getType() == Integer.TYPE) {
            this.type = 4;
            this.min = col.getMinValue().getDouble();
            this.max = col.getMaxValue().getDouble();
            int binWidth = (int)(1.0 + (this.max - this.min) / 50.0);
            this.bins = (int)(1.0 + (this.max - this.min) / (double)binWidth);
            this.min -= 0.5;
            this.max += 0.5;
        } else if ((class$java$util$Date == null ? (class$java$util$Date = Profile.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(col.getType())) {
            this.type = 3;
            this.min = (double)col.getMinValue().getDate().getTime() / 1000.0;
            this.max = (double)col.getMaxValue().getDate().getTime() / 1000.0;
        } else {
            this.type = 1;
            this.min = col.getMinValue().getDouble();
            this.max = col.getMaxValue().getDouble();
        }
    }

    public void setRunnable(Runnable run) {
        this.run = run;
    }

    public int getBins() {
        return this.bins;
    }

    public int getAxisType() {
        return this.type;
    }

    public double getMax() {
        if (this.type == 4) {
            return this.max - 0.5;
        }
        return this.max;
    }

    public double getMin() {
        if (this.type == 4) {
            return this.min + 0.5;
        }
        return this.min;
    }

    public String getTitle() {
        return this.col.getName();
    }

    public String[] getAxisLabels() {
        return null;
    }

    public double[][] rebin(int bins, double min, double max, boolean param3, boolean param4) {
        if (bins != this.bins || min != this.min || max != this.max) {
            this.bins = bins;
            this.min = min;
            this.max = max;
            this.run.run();
        }
        return new double[][]{this.data, this.dataErrors};
    }

    public boolean isRebinnable() {
        return true;
    }

    public void start() {
        this.binWidth = (this.max - this.min) / (double)this.bins;
        this.n = new double[this.bins];
        this.hist = new double[this.bins];
        this.error = new double[this.bins];
    }

    public DataSource getDataSource() {
        return this;
    }

    public void fill(NTupleCursor cursor) {
        double v;
        if (this.type == 3) {
            Date d = this.col.getValue(cursor).getDate();
            if (d == null) {
                return;
            }
            v = (double)d.getTime() / 1000.0 - this.min;
        } else {
            v = this.type == 4 ? this.col.getValue(cursor).getDouble() - this.min : this.col.getValue(cursor).getDouble() - this.min;
        }
        if (v < 0.0) {
            return;
        }
        int bin = (int)Math.floor(v / this.binWidth);
        if (bin >= this.bins) {
            return;
        }
        int n = bin;
        this.n[n] = this.n[n] + 1.0;
        double w = this.colW.getValue(cursor).getDouble();
        int n2 = bin;
        this.hist[n2] = this.hist[n2] + w;
        int n3 = bin;
        this.error[n3] = this.error[n3] + w * w;
    }

    public void end() {
        int i = 0;
        while (i < this.error.length) {
            int n = i;
            this.hist[n] = this.hist[n] / this.n[i];
            this.error[i] = Math.sqrt(this.error[i] / this.n[i] - this.hist[i] * this.hist[i]);
            ++i;
        }
        this.data = this.hist;
        this.dataErrors = this.error;
        this.setChanged();
        this.notifyObservers(hu);
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

