/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import jas.tuple.MutableNTuple;
import jas.tuple.NTuple;
import jas.tuple.NTupleColumn;
import jas.tuple.jel.ExpressionField;
import jas.tuple.jel.JELColumn;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewColumnDialog
extends JDialog
implements DocumentListener {
    private NTuple tuple;
    private JPanel mainPanel;
    private JLabel jLabel1;
    private JTextField nameField;
    private JLabel jLabel2;
    private ExpressionField expressionField;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;

    public NewColumnDialog(Frame frame, NTuple tuple) {
        super(frame, true);
        this.tuple = tuple;
        this.initComponents();
        this.doEnable();
        this.getRootPane().setDefaultButton(this.okButton);
        this.nameField.getDocument().addDocumentListener(this);
        this.expressionField.getDocument().addDocumentListener(this);
        this.expressionField.setNTuple(tuple);
    }

    private void doEnable() {
        this.okButton.setEnabled(this.nameField.getText().length() > 0 && this.expressionField.getText().length() > 0);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.expressionField = new ExpressionField();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.setTitle("Define New Column");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewColumnDialog.this.closeDialog(evt);
            }
        });
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.jLabel1.setText("Column Name");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 13;
        this.mainPanel.add((Component)this.jLabel1, gridBagConstraints1);
        this.nameField.setToolTipText("Enter name for new column");
        this.nameField.setColumns(30);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.mainPanel.add((Component)this.nameField, gridBagConstraints1);
        this.jLabel2.setText("Expression");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 13;
        this.mainPanel.add((Component)this.jLabel2, gridBagConstraints1);
        this.expressionField.setToolTipText("Expression to be evaluated");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        this.mainPanel.add((Component)this.expressionField, gridBagConstraints1);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewColumnDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewColumnDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.helpButton.setMnemonic('H');
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewColumnDialog.this.helpButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.helpButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String colName = this.nameField.getText();
        try {
            NTupleColumn col = this.tuple.getColumnByName(colName);
            if (col != null) {
                JOptionPane.showMessageDialog(this, "Column " + colName + " already in use", "Error", 0);
            } else {
                CompiledExpression exp = this.expressionField.compile(null);
                col = new JELColumn(this.tuple, colName, this.expressionField.getText(), exp);
                ((MutableNTuple)this.tuple).addColumn(col);
                this.dispose();
            }
        }
        catch (CompilationException x) {
            String message = x.getMessage();
            JOptionPane.showMessageDialog(this, (Object)x, "Compilation Error", 0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }
}

