/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import jas.tuple.jel.ExpressionField;
import jas.tuple.jel.JELCut;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JELCutPanel
extends JPanel
implements DocumentListener {
    private JELCut cut;
    private ExpressionField expression;
    private JButton apply;

    public JELCutPanel(JELCut cut) {
        this.cut = cut;
        this.initComponents();
        this.expression.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.expression = new ExpressionField();
        this.apply = new JButton();
        this.setLayout(new BorderLayout());
        this.expression.setToolTipText("Boolean Expression");
        this.expression.setColumns(20);
        this.expression.setText(this.cut.getExpression());
        this.expression.setNTuple(this.cut.getNTuple());
        this.expression.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JELCutPanel.this.expressionActionPerformed(evt);
            }
        });
        this.add((Component)this.expression, "Center");
        this.apply.setText("Apply");
        this.apply.setEnabled(false);
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JELCutPanel.this.applyActionPerformed(evt);
            }
        });
        this.add((Component)this.apply, "East");
    }

    private void expressionActionPerformed(ActionEvent evt) {
        if (this.apply.isEnabled()) {
            this.apply.doClick();
        }
    }

    private void applyActionPerformed(ActionEvent evt) {
        try {
            this.apply.setEnabled(false);
            CompiledExpression ce = this.expression.compile(Boolean.TYPE);
            this.cut.setExpression(ce, this.expression.getText());
        }
        catch (CompilationException x) {
            JOptionPane.showMessageDialog(this, x.getMessage(), "Compilation Error", 0);
        }
    }

    private void doEnable() {
        this.apply.setEnabled(this.expression.getText() != this.cut.getExpression());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }
}

