/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import jas.tuple.NTuple;
import jas.tuple.jel.ExpressionField;
import jas.tuple.jel.JELColumn;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JELColumnProperties
extends JDialog
implements DocumentListener {
    private JELColumn column;
    private NTuple tuple;
    private JPanel jPanel1;
    private JButton ok;
    private JButton cancel;
    private JButton help;
    private JPanel jPanel2;
    private JLabel columnName;
    private ExpressionField expression;

    public JELColumnProperties(Frame parent, JELColumn column, NTuple tuple) {
        super(parent, false);
        this.column = column;
        this.tuple = tuple;
        this.initComponents();
        this.expression.getDocument().addDocumentListener(this);
        this.doEnable();
        this.getRootPane().setDefaultButton(this.ok);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.ok = new JButton();
        this.cancel = new JButton();
        this.help = new JButton();
        this.jPanel2 = new JPanel();
        this.columnName = new JLabel();
        this.expression = new ExpressionField();
        this.setTitle("Column Properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JELColumnProperties.this.closeDialog(evt);
            }
        });
        this.ok.setMnemonic('O');
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JELColumnProperties.this.okActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.ok);
        this.cancel.setMnemonic('C');
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JELColumnProperties.this.cancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancel);
        this.help.setMnemonic('H');
        this.help.setText("Help");
        this.help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JELColumnProperties.this.helpActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.help);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.columnName.setText(this.column.getName() + "=");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 13;
        this.jPanel2.add((Component)this.columnName, gridBagConstraints1);
        this.expression.setEditable(false);
        this.expression.setText(this.column.getExpression());
        this.expression.setNTuple(this.tuple);
        this.expression.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JELColumnProperties.this.expressionActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.expression, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.pack();
    }

    private void expressionActionPerformed(ActionEvent evt) {
    }

    private void okActionPerformed(ActionEvent evt) {
        try {
            CompiledExpression exp = this.expression.compile(null);
            this.dispose();
        }
        catch (CompilationException x) {
            String message = x.getMessage();
            JOptionPane.showMessageDialog(this, (Object)x, "Compilation Error", 0);
        }
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void helpActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    private void doEnable() {
        this.ok.setEnabled(!this.expression.getText().equals(this.column.getExpression()));
    }
}

