/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import jas.tuple.NTuple;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.Value;
import jas.tuple.jel.Compiler;
import jas.tuple.jel.NTupleColumnEvaluator;

public class JELColumn
implements NTupleColumn {
    private NTuple tuple;
    private String name;
    private String orig;
    private CompiledExpression expression;
    private NTupleColumnEvaluator evaluator;
    private Object[] dyn;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private Value value = new Value();
    private Class[] types = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = JELColumn.class$("java.lang.Object")) : class$java$lang$Object};
    static /* synthetic */ Class class$java$lang$Object;

    public JELColumn(NTuple tuple, String columnName, String expression) throws CompilationException {
        this(tuple, columnName, expression, Compiler.compile(tuple, expression, null));
    }

    public JELColumn(NTuple tuple, String columnName, String orig, CompiledExpression exp) {
        this.tuple = tuple;
        this.name = columnName;
        this.orig = orig;
        this.expression = exp;
        this.evaluator = new NTupleColumnEvaluator(tuple);
        this.dyn = new Object[]{this.evaluator};
        if (exp.getType() > 2 && exp.getType() < 8) {
            NTupleCursor cursor = tuple.getCursor();
            this.evaluator.setCursor(cursor);
            Value v = new Value();
            while (cursor.nextRow()) {
                this.getValue(v);
                double d = v.getDouble();
                if (Double.isNaN(this.min) || d < this.min) {
                    this.min = d;
                }
                if (!Double.isNaN(this.max) && !(d > this.max)) continue;
                this.max = d;
            }
        }
    }

    public Value getValue(NTupleCursor cursor) {
        this.evaluator.setCursor(cursor);
        return this.getValue(this.value);
    }

    private Value getValue(Value result) {
        try {
            switch (this.expression.getType()) {
                case 0: {
                    return result.set(this.expression.evaluate_boolean(this.dyn));
                }
                case 1: {
                    return result.set(this.expression.evaluate_byte(this.dyn));
                }
                case 7: {
                    return result.set(this.expression.evaluate_double(this.dyn));
                }
                case 6: {
                    return result.set(this.expression.evaluate_float(this.dyn));
                }
                case 3: {
                    return result.set(this.expression.evaluate_short(this.dyn));
                }
                case 4: {
                    return result.set(this.expression.evaluate_int(this.dyn));
                }
            }
            return result.set(this.expression.evaluate(this.dyn));
        }
        catch (Throwable t) {
            result.set(Double.NaN);
            return result;
        }
    }

    public Class getType() {
        return this.types[this.expression.getType()];
    }

    public String getName() {
        return this.name;
    }

    public Value getMinValue() {
        Value v = new Value();
        return v.set(this.min);
    }

    public Value getMaxValue() {
        Value v = new Value();
        return v.set(this.max);
    }

    public String getExpression() {
        return this.orig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

