/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import jas.tuple.NTuple;
import jas.tuple.NTupleColumn;
import jas.tuple.jel.Compiler;
import jas.tuple.jel.NTupleNameResolver;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class ExpressionField
extends JTextField {
    private NTuple tuple;

    public CompiledExpression compile(Class resultType) throws CompilationException {
        try {
            return Compiler.compile(this.tuple, this.getText(), resultType);
        }
        catch (CompilationException x) {
            this.setCaretPosition(x.getColumn());
            this.grabFocus();
            throw x;
        }
    }

    public void setNTuple(NTuple tuple) {
        this.tuple = tuple;
        PopupMenu menu = new PopupMenu();
        this.addMouseListener(new PopupListener(menu));
    }

    private class ColumnMenuItem
    extends JMenuItem {
        private NTupleColumn col;

        ColumnMenuItem(NTupleColumn col) {
            super(col.getName());
            this.col = col;
        }

        protected void fireActionPerformed(ActionEvent e) {
            String name = this.col.getName();
            if (this.isJavaIdentifier(name)) {
                ExpressionField.this.replaceSelection(name);
            } else {
                Class type = this.col.getType();
                String typeName = NTupleNameResolver.nameForType(type);
                ExpressionField.this.replaceSelection("get" + typeName + "Property(\"" + name + "\")");
            }
        }

        private boolean isJavaIdentifier(String name) {
            if (name.length() < 0) {
                return false;
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                return false;
            }
            int i = 1;
            while (i < name.length()) {
                if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class PopupMenu
    extends JPopupMenu {
        PopupMenu() {
            JMenu menu = new JMenu("Insert");
            int i = 0;
            while (i < ExpressionField.this.tuple.getNColumns()) {
                menu.add(new ColumnMenuItem(ExpressionField.this.tuple.getColumn(i)));
                ++i;
            }
            this.add(menu);
        }
    }

    private static class PopupListener
    extends MouseAdapter {
        private JPopupMenu menu;

        PopupListener(JPopupMenu menu) {
            this.menu = menu;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        private void maybePopup(MouseEvent me) {
            if (this.menu.isPopupTrigger(me)) {
                this.menu.show(me.getComponent(), me.getX(), me.getY());
            }
        }
    }
}

