/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.cut;

import jas.tuple.CutChangedEvent;
import jas.tuple.CutListener;
import jas.tuple.cut.NumericCut1D;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.freehep.util.images.ImageHandler;

public class NumericCut1DPanel
extends JPanel
implements CutListener {
    private NumericCut1D cut;
    private MinSliderModel model1 = new MinSliderModel();
    private MaxSliderModel model2 = new MaxSliderModel();
    private static final Icon lockedIcon = ImageHandler.getIcon((String)"lock.gif", (Class)(class$jas$tuple$cut$NumericCut1DPanel == null ? (class$jas$tuple$cut$NumericCut1DPanel = NumericCut1DPanel.class$("jas.tuple.cut.NumericCut1DPanel")) : class$jas$tuple$cut$NumericCut1DPanel));
    private static final Icon unlockIcon = ImageHandler.getIcon((String)"unlock.gif", (Class)(class$jas$tuple$cut$NumericCut1DPanel == null ? (class$jas$tuple$cut$NumericCut1DPanel = NumericCut1DPanel.class$("jas.tuple.cut.NumericCut1DPanel")) : class$jas$tuple$cut$NumericCut1DPanel));
    private boolean locked = false;
    private double delta;
    private double Xmin;
    private double Xmax;
    private double value1;
    private double value2;
    private JTextField label1;
    private JTextField label2;
    private boolean isChanging = false;
    static /* synthetic */ Class class$jas$tuple$cut$NumericCut1DPanel;

    public NumericCut1DPanel(NumericCut1D cut1) {
        super(new BorderLayout());
        this.cut = cut1;
        this.Xmin = this.cut.getMin();
        this.Xmax = this.cut.getMax();
        JSlider slider1 = new JSlider(this.model1);
        JSlider slider2 = new JSlider(this.model2);
        JPanel sp1 = new JPanel(new BorderLayout());
        JPanel sp2 = new JPanel(new BorderLayout());
        this.label1 = new JTextField(6);
        this.label2 = new JTextField(6);
        this.label1.setEditable(false);
        this.label2.setEditable(false);
        sp1.add((Component)slider1, "Center");
        sp2.add((Component)slider2, "Center");
        sp1.add((Component)this.label1, "East");
        sp2.add((Component)this.label2, "East");
        JPanel sliders = new JPanel(new BorderLayout());
        sliders.add((Component)sp1, "North");
        sliders.add((Component)sp2, "South");
        JPanel bottom = new JPanel();
        final JToggleButton lock = new JToggleButton();
        lock.setSelectedIcon(lockedIcon);
        lock.setIcon(unlockIcon);
        lock.setMargin(new Insets(0, 0, 0, 0));
        lock.setBorderPainted(false);
        lock.setContentAreaFilled(false);
        lock.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NumericCut1DPanel.this.locked = lock.isSelected();
                NumericCut1DPanel.this.delta = NumericCut1DPanel.this.value2 - NumericCut1DPanel.this.value1;
            }
        });
        bottom.add(lock);
        bottom.add(sliders);
        this.add((Component)bottom, "South");
    }

    public void cutChanged(CutChangedEvent e) {
        if (!this.isChanging) {
            this.isChanging = true;
            this.model1.setValue(this.cut.getValue1());
            this.model2.setValue(this.cut.getValue2());
            this.isChanging = false;
        }
    }

    public void addNotify() {
        this.model1.setValue(this.cut.getValue1());
        this.model2.setValue(this.cut.getValue2());
        this.cut.addCutListener(this);
        super.addNotify();
    }

    public void removeNotify() {
        this.cut.removeCutListener(this);
        super.removeNotify();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MaxSliderModel
    extends DefaultBoundedRangeModel {
        MaxSliderModel() {
            super(0, 0, 0, 1000);
        }

        public int getValue() {
            return (int)(1000.0 * (NumericCut1DPanel.this.value2 - NumericCut1DPanel.this.Xmin) / (NumericCut1DPanel.this.Xmax - NumericCut1DPanel.this.Xmin));
        }

        public void setValue(int newValue) {
            this.setValue(NumericCut1DPanel.this.Xmin + (double)newValue / 1000.0 * (NumericCut1DPanel.this.Xmax - NumericCut1DPanel.this.Xmin));
            if (NumericCut1DPanel.this.locked) {
                NumericCut1DPanel.this.model1.setValue(Math.max(NumericCut1DPanel.this.Xmin, NumericCut1DPanel.this.value2 - NumericCut1DPanel.this.delta));
            } else if (NumericCut1DPanel.this.value1 > NumericCut1DPanel.this.value2) {
                NumericCut1DPanel.this.model1.setValue(NumericCut1DPanel.this.value2);
            }
            if (!NumericCut1DPanel.this.isChanging) {
                NumericCut1DPanel.this.isChanging = true;
                NumericCut1DPanel.this.cut.setRange(NumericCut1DPanel.this.value1, NumericCut1DPanel.this.value2);
                NumericCut1DPanel.this.isChanging = false;
            }
        }

        void setValue(double newValue) {
            if (newValue == NumericCut1DPanel.this.value2) {
                return;
            }
            NumericCut1DPanel.this.value2 = newValue;
            String s = String.valueOf(NumericCut1DPanel.this.value2);
            s = s.substring(0, Math.min(6, s.length()));
            NumericCut1DPanel.this.label2.setText(s);
            this.fireStateChanged();
        }
    }

    class MinSliderModel
    extends DefaultBoundedRangeModel {
        MinSliderModel() {
            super(0, 0, 0, 1000);
        }

        public int getValue() {
            return (int)(1000.0 * (NumericCut1DPanel.this.value1 - NumericCut1DPanel.this.Xmin) / (NumericCut1DPanel.this.Xmax - NumericCut1DPanel.this.Xmin));
        }

        public void setValue(int newValue) {
            this.setValue(NumericCut1DPanel.this.Xmin + (double)newValue / 1000.0 * (NumericCut1DPanel.this.Xmax - NumericCut1DPanel.this.Xmin));
            if (NumericCut1DPanel.this.locked) {
                NumericCut1DPanel.this.model2.setValue(Math.min(NumericCut1DPanel.this.Xmax, NumericCut1DPanel.this.value1 + NumericCut1DPanel.this.delta));
            } else if (NumericCut1DPanel.this.value1 > NumericCut1DPanel.this.value2) {
                NumericCut1DPanel.this.model2.setValue(NumericCut1DPanel.this.value1);
            }
            if (!NumericCut1DPanel.this.isChanging) {
                NumericCut1DPanel.this.isChanging = true;
                NumericCut1DPanel.this.cut.setRange(NumericCut1DPanel.this.value1, NumericCut1DPanel.this.value2);
                NumericCut1DPanel.this.isChanging = false;
            }
        }

        void setValue(double newValue) {
            if (newValue == NumericCut1DPanel.this.value1) {
                return;
            }
            NumericCut1DPanel.this.value1 = newValue;
            String s = String.valueOf(NumericCut1DPanel.this.value1);
            s = s.substring(0, Math.min(6, s.length()));
            NumericCut1DPanel.this.label1.setText(s);
            this.fireStateChanged();
        }
    }
}

