/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.cut;

import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.cut.AbstractCut;

public class NumericCut1D
extends AbstractCut {
    private NTupleColumn col;
    private int type;
    private double min;
    private double max;
    private double value1;
    private double value2;

    public NumericCut1D(String name, NTupleColumn col, int type) {
        super(name);
        this.col = col;
        this.type = type;
        this.min = col.getMinValue().getDouble();
        this.max = col.getMaxValue().getDouble();
        this.value1 = this.min + 0.25 * (this.max - this.min);
        this.value2 = this.min + 0.75 * (this.max - this.min);
    }

    double getMin() {
        return this.min;
    }

    double getMax() {
        return this.max;
    }

    double getValue1() {
        return this.value1;
    }

    double getValue2() {
        return this.value2;
    }

    void setRange(double min, double max) {
        this.value1 = min;
        this.value2 = max;
        this.fireCutChanged();
    }

    public NTupleColumn getColumn() {
        return this.col;
    }

    public boolean accept(NTupleCursor cursor) {
        double x = this.col.getValue(cursor).getDouble();
        switch (this.type) {
            case 0: {
                return x < this.value1;
            }
            case 1: {
                return x > this.value1;
            }
            case 2: {
                return x > this.value1 && x < this.value2;
            }
            case 3: {
                return x < this.value1 || x > this.value2;
            }
        }
        return false;
    }
}

