/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.cut;

import jas.tuple.NTupleCut;
import jas.tuple.TreeTuple;
import jas.tuple.cut.AddCutDialog;
import jas.tuple.cut.AddCutToCutSetDialog;
import jas.tuple.cut.CutDialog;
import jas.tuple.cut.CutSet;
import jas.tuple.cut.CutSetTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CutSetPanel
extends JPanel {
    private CutSet cutSet;
    private TreeTuple tuple;
    private JPanel jPanel1;
    private JCheckBox details;
    private JPanel jPanel2;
    private JButton add;
    private JButton remove;
    private JButton newButton;
    private JScrollPane cutScroll;
    private JTable table;
    static /* synthetic */ Class class$java$awt$Dialog;
    static /* synthetic */ Class class$javax$swing$JDialog;

    public CutSetPanel(CutSet cs, TreeTuple tuple) {
        this.cutSet = cs;
        this.tuple = tuple;
        this.initComponents();
        this.detailsActionPerformed(null);
    }

    private JPanel createCutPanel() {
        final JPanel cutPanel = new JPanel();
        cutPanel.setLayout(new BoxLayout(cutPanel, 1));
        int i = 0;
        while (i < this.cutSet.getNCuts()) {
            NTupleCut cut = this.cutSet.getCut(i);
            JPanel p = this.createCutWrapper(cut);
            cutPanel.add(p);
            ++i;
        }
        ListDataListener l = new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                int i = listDataEvent.getIndex0();
                while (i <= listDataEvent.getIndex1()) {
                    NTupleCut cut = CutSetPanel.this.cutSet.getCut(i);
                    JPanel p = CutSetPanel.this.createCutWrapper(cut);
                    cutPanel.add((Component)p, i);
                    cutPanel.revalidate();
                    ++i;
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                int i = listDataEvent.getIndex0();
                while (i <= listDataEvent.getIndex1()) {
                    cutPanel.remove(i);
                    cutPanel.revalidate();
                    ++i;
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        };
        this.cutSet.addListDataListener(l);
        JPanel spacer = new JPanel(new BorderLayout());
        spacer.add((Component)cutPanel, "North");
        return spacer;
    }

    private JPanel createCutWrapper(NTupleCut cut) {
        JPanel p = new JPanel(new BorderLayout());
        JComponent cp = CutDialog.createPanel(cut, this.tuple);
        cp.setBorder(BorderFactory.createTitledBorder(cut.getName()));
        p.add((Component)cp, "Center");
        Box b = Box.createVerticalBox();
        JCheckBox disable = new JCheckBox("Disable");
        disable.getInsets().bottom = 0;
        JCheckBox invert = new JCheckBox("Invert");
        invert.getInsets().top = 0;
        int state = this.cutSet.getCutState(cut);
        disable.setSelected(state == 2);
        invert.setSelected(state == 1);
        invert.setEnabled(state != 2);
        CutEnabler al = new CutEnabler(this.cutSet, cut, disable, invert);
        disable.addActionListener(al);
        invert.addActionListener(al);
        b.add(Box.createVerticalGlue());
        b.add(disable);
        b.add(invert);
        b.add(Box.createVerticalGlue());
        p.add((Component)b, "East");
        return p;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.details = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.add = new JButton();
        this.remove = new JButton();
        this.newButton = new JButton();
        this.cutScroll = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.details.setMnemonic('S');
        this.details.setText("Show Cut Details");
        this.details.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CutSetPanel.this.detailsActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.details, "West");
        this.add.setToolTipText("Add cut to cut set");
        this.add.setMnemonic('A');
        this.add.setText("Add...");
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CutSetPanel.this.addActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.add);
        this.remove.setToolTipText("Remove selected cut from cut set");
        this.remove.setMnemonic('R');
        this.remove.setText("Remove");
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CutSetPanel.this.removeActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.remove);
        this.newButton.setToolTipText("Create a new cut and add it to the cut set");
        this.newButton.setMnemonic('N');
        this.newButton.setText("New...");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CutSetPanel.this.newButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.newButton);
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.add((Component)this.jPanel1, "North");
        this.add((Component)this.cutScroll, "Center");
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        Dialog frame = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = CutSetPanel.class$("java.awt.Dialog")) : class$java$awt$Dialog, this);
        AddCutDialog dlg = new AddCutDialog(frame, this.tuple);
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.show();
        NTupleCut cut = dlg.getCut();
        if (cut != null) {
            this.cutSet.addCut(cut);
        }
    }

    private void removeActionPerformed(ActionEvent evt) {
        int[] rows = this.table.getSelectedRows();
        ArrayList<NTupleCut> cutsToBeRemoved = new ArrayList<NTupleCut>();
        int i = 0;
        while (i < rows.length) {
            cutsToBeRemoved.add(this.cutSet.getCut(rows[i]));
            ++i;
        }
        int i2 = 0;
        while (i2 < cutsToBeRemoved.size()) {
            this.cutSet.removeCut((NTupleCut)cutsToBeRemoved.get(i2));
            ++i2;
        }
    }

    private void addActionPerformed(ActionEvent evt) {
        CutSet all = this.tuple.allCuts();
        Vector<NTupleCut> eligible = new Vector<NTupleCut>();
        int i = 0;
        while (i < all.getNCuts()) {
            NTupleCut cut = all.getCut(i);
            if (!(this.cutSet.contains(cut, false) || cut instanceof CutSet && ((CutSet)cut).contains(this.cutSet, true))) {
                eligible.add(cut);
            }
            ++i;
        }
        JDialog parent = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = CutSetPanel.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, this);
        AddCutToCutSetDialog dlg = new AddCutToCutSetDialog((Dialog)parent, eligible);
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.show();
        if (dlg.getSelectedCut() != null) {
            this.cutSet.addCut(dlg.getSelectedCut());
        }
    }

    private void detailsActionPerformed(ActionEvent evt) {
        if (this.details.isSelected()) {
            this.cutScroll.setViewportView(this.createCutPanel());
        } else {
            this.table = new JTable(new CutSetTable(this.cutSet));
            this.cutScroll.setViewportView(this.table);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    CutSetPanel.this.remove.setEnabled(CutSetPanel.this.table.getSelectedRowCount() > 0);
                }
            });
        }
        this.remove.setEnabled(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CutEnabler
    implements ActionListener {
        private CutSet cutSet;
        private NTupleCut cut;
        private JCheckBox disable;
        private JCheckBox invert;

        CutEnabler(CutSet cutSet, NTupleCut cut, JCheckBox disable, JCheckBox invert) {
            this.cutSet = cutSet;
            this.cut = cut;
            this.disable = disable;
            this.invert = invert;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int state = this.disable.isSelected() ? 2 : (this.invert.isSelected() ? 1 : 0);
            this.cutSet.setCutState(this.cut, state);
            this.invert.setEnabled(state != 2);
        }
    }
}

