/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.cut;

import jas.tuple.CutChangedEvent;
import jas.tuple.CutListener;
import jas.tuple.NTupleCursor;
import jas.tuple.NTupleCut;
import jas.tuple.cut.AbstractCut;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CutSet
extends AbstractCut
implements CutListener {
    public static final int CUT_ENABLED = 0;
    public static final int CUT_INVERTED = 1;
    public static final int CUT_DISABLED = 2;
    private List cuts = new ArrayList();
    private Map map = new HashMap();
    private int lastRow = -1;
    private boolean lastResult = false;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public CutSet(String name) {
        super(name);
    }

    public boolean accept(NTupleCursor cursor) {
        int row = cursor.getRow();
        if (row == this.lastRow) {
            return this.lastResult;
        }
        this.lastRow = row;
        int i = this.cuts.size();
        while (i > 0) {
            CutState cs = (CutState)this.cuts.get(--i);
            int state = cs.state;
            if (state == 2 || cs.cut.accept(cursor) == (state == 0)) continue;
            this.lastResult = false;
            return false;
        }
        this.lastResult = true;
        return true;
    }

    public void addCut(NTupleCut cut) {
        CutState cs = new CutState(cut, 0);
        int index = this.cuts.size();
        this.cuts.add(cs);
        this.map.put(cut, cs);
        this.fireCutAdded(index);
        this.fireCutChanged();
        cut.addCutListener(this);
    }

    public void removeCut(NTupleCut cut) {
        cut.removeCutListener(this);
        CutState cs = (CutState)this.map.remove(cut);
        int index = this.cuts.indexOf(cs);
        this.cuts.remove(cs);
        this.fireCutRemoved(index);
        this.fireCutChanged();
    }

    public void cutChanged(CutChangedEvent e) {
        CutState cs = (CutState)this.map.get(e.getSource());
        if (cs != null && cs.state != 2) {
            this.fireCutChanged();
        }
    }

    public void setCutState(NTupleCut cut, int state) {
        CutState cs = (CutState)this.map.get(cut);
        if (cs.state != state) {
            cs.state = state;
            this.fireCutChanged();
        }
    }

    public int getCutState(NTupleCut cut) {
        return ((CutState)this.map.get((Object)cut)).state;
    }

    public int getNCuts() {
        return this.cuts.size();
    }

    public NTupleCut getCut(int index) {
        return ((CutState)this.cuts.get((int)index)).cut;
    }

    boolean contains(NTupleCut cut, boolean recurse) {
        int i = this.cuts.size();
        while (i > 0) {
            CutState cs = (CutState)this.cuts.get(--i);
            if (cs.cut == cut) {
                return true;
            }
            if (!recurse || !(cs.cut instanceof CutSet) || !((CutSet)cs.cut).contains(cut, true)) continue;
            return true;
        }
        return false;
    }

    public void addListDataListener(ListDataListener l) {
        this.listeners.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = CutSet.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = CutSet.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l);
    }

    private void fireCutAdded(int index) {
        if (this.listeners.getListenerCount(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = CutSet.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener) == 0) {
            return;
        }
        ListDataEvent e = new ListDataEvent(this, 1, index, index);
        ListDataListener[] l = (ListDataListener[])this.listeners.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = CutSet.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
        int i = 0;
        while (i < l.length) {
            l[i].intervalAdded(e);
            ++i;
        }
    }

    private void fireCutRemoved(int index) {
        if (this.listeners.getListenerCount(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = CutSet.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener) == 0) {
            return;
        }
        ListDataEvent e = new ListDataEvent(this, 1, index, index);
        ListDataListener[] l = (ListDataListener[])this.listeners.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = CutSet.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
        int i = 0;
        while (i < l.length) {
            l[i].intervalRemoved(e);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CutState {
        int state;
        NTupleCut cut;

        CutState(NTupleCut cut, int state) {
            this.state = state;
            this.cut = cut;
        }
    }
}

