/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.cut;

import jas.tuple.NTupleCut;
import jas.tuple.NTupleListCellRenderer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddCutToCutSetDialog
extends JDialog {
    private JScrollPane jScrollPane1;
    private JList cutList;
    private JPanel jPanel1;
    private JButton okButton;
    private JButton cancelButton;
    private NTupleCut selectedCut;
    private Vector cuts;

    public AddCutToCutSetDialog(Dialog parent, Vector cuts) {
        super(parent, true);
        this.cuts = cuts;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.cutList = new JList(this.cuts);
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Add Cut");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AddCutToCutSetDialog.this.closeDialog(evt);
            }
        });
        this.cutList.setCellRenderer(new NTupleListCellRenderer());
        this.cutList.setSelectionMode(0);
        this.cutList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                AddCutToCutSetDialog.this.cutListValueChanged(evt);
            }
        });
        this.cutList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AddCutToCutSetDialog.this.cutListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.cutList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddCutToCutSetDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddCutToCutSetDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void cutListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && this.okButton.isEnabled()) {
            this.okButton.doClick();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.selectedCut = (NTupleCut)this.cutList.getSelectedValue();
        this.dispose();
    }

    private void cutListValueChanged(ListSelectionEvent evt) {
        this.okButton.setEnabled(this.cutList.getSelectedValue() != null);
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    NTupleCut getSelectedCut() {
        return this.selectedCut;
    }
}

