/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple.cut;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import jas.tuple.NTuple;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCut;
import jas.tuple.NTupleListCellRenderer;
import jas.tuple.NTupleListModel;
import jas.tuple.TreeTuple;
import jas.tuple.cut.CutSet;
import jas.tuple.cut.CutSetTable;
import jas.tuple.cut.NumericCut1D;
import jas.tuple.jel.ExpressionField;
import jas.tuple.jel.JELColumn;
import jas.tuple.jel.JELCut;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddCutDialog
extends JDialog
implements DocumentListener,
ChangeListener {
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JTabbedPane jTabbedPane1;
    private JPanel mainPanel;
    private JLabel jLabel1;
    private JTextField cutName;
    private JLabel jLabel2;
    private JComboBox cutType;
    private JRadioButton columnCheckbox;
    private JComboBox column;
    private JRadioButton expressionCheckbox;
    private ExpressionField numericExpression;
    private JPanel GeneralPanel;
    private JLabel jLabel4;
    private JTextField expressionName;
    private JLabel jLabel5;
    private ExpressionField expression;
    private JPanel cutSetPanel;
    private JPanel jPanel2;
    private JLabel jLabel3;
    private JTextField cutSetName;
    private JButton add;
    private JButton remove;
    private JButton newCut;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private NTuple tuple;
    private TreeTuple tt;
    private NTupleCut cut;
    private CutSet temp = new CutSet("temp");
    static /* synthetic */ Class class$java$lang$Number;

    public AddCutDialog(Frame parent, TreeTuple tt) {
        super(parent, true);
        this.init(tt);
    }

    public AddCutDialog(Dialog parent, TreeTuple tt) {
        super(parent, true);
        this.init(tt);
    }

    private void init(TreeTuple tt) {
        this.tuple = tt.getNTuple();
        this.tt = tt;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.numericExpression.getDocument().addDocumentListener(this);
        this.numericExpression.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                AddCutDialog.this.expressionCheckbox.setSelected(true);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                AddCutDialog.this.expressionCheckbox.setSelected(true);
            }
        });
        this.cutName.getDocument().addDocumentListener(this);
        this.expressionName.getDocument().addDocumentListener(this);
        this.cutSetName.getDocument().addDocumentListener(this);
        this.expression.getDocument().addDocumentListener(this);
        this.jTabbedPane1.addChangeListener(this);
        this.expressionCheckbox.addChangeListener(this);
        this.doEnable();
    }

    private void doEnable() {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.okButton.setEnabled(this.cutName.getText().length() > 0 && (this.columnCheckbox.isSelected() || this.numericExpression.getText().length() > 0));
        } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
            this.okButton.setEnabled(this.expressionName.getText().length() > 0 && this.expression.getText().length() > 0);
        } else {
            this.okButton.setEnabled(this.cutSetName.getText().length() > 0);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.doEnable();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.doEnable();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.cutName = new JTextField();
        this.jLabel2 = new JLabel();
        this.cutType = new JComboBox();
        this.columnCheckbox = new JRadioButton();
        this.column = new JComboBox();
        this.expressionCheckbox = new JRadioButton();
        this.numericExpression = new ExpressionField();
        this.GeneralPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.expressionName = new JTextField();
        this.jLabel5 = new JLabel();
        this.expression = new ExpressionField();
        this.cutSetPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.cutSetName = new JTextField();
        this.add = new JButton();
        this.remove = new JButton();
        this.newCut = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setTitle("Add Cut...");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AddCutDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddCutDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddCutDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.helpButton.setMnemonic('H');
        this.helpButton.setText("Help");
        this.buttonPanel.add(this.helpButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jTabbedPane1.setBorder(new EmptyBorder(new Insets(10, 1, 1, 1)));
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.jLabel1.setText("Cut Name");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 13;
        this.mainPanel.add((Component)this.jLabel1, gridBagConstraints1);
        this.cutName.setToolTipText("Name for the cut");
        this.cutName.setColumns(15);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.mainPanel.add((Component)this.cutName, gridBagConstraints1);
        this.jLabel2.setText("Cut Type");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 13;
        this.mainPanel.add((Component)this.jLabel2, gridBagConstraints1);
        this.cutType.setModel(new DefaultComboBoxModel<String>(new String[]{"x < Cut", "x > Cut", "Cut1 < x < Cut2", "x < Cut1 || x > Cut2"}));
        this.cutType.setToolTipText("Type of cut");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.anchor = 17;
        this.mainPanel.add((Component)this.cutType, gridBagConstraints1);
        this.columnCheckbox.setSelected(true);
        this.columnCheckbox.setText("Column");
        this.buttonGroup1.add(this.columnCheckbox);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 13;
        this.mainPanel.add((Component)this.columnCheckbox, gridBagConstraints1);
        this.column.setModel(new NTupleListModel(this.tuple, class$java$lang$Number == null ? (class$java$lang$Number = AddCutDialog.class$("java.lang.Number")) : class$java$lang$Number));
        this.column.setToolTipText("Column to apply cut to");
        this.column.setRenderer(new NTupleListCellRenderer());
        this.column.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddCutDialog.this.columnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.anchor = 17;
        this.mainPanel.add((Component)this.column, gridBagConstraints1);
        this.expressionCheckbox.setText("Expression");
        this.buttonGroup1.add(this.expressionCheckbox);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 13;
        this.mainPanel.add((Component)this.expressionCheckbox, gridBagConstraints1);
        this.numericExpression.setToolTipText("Numeric Expression to Cut On");
        this.numericExpression.setNTuple(this.tuple);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        this.mainPanel.add((Component)this.numericExpression, gridBagConstraints1);
        this.jTabbedPane1.addTab("Numeric 1D Cut", this.mainPanel);
        this.GeneralPanel.setLayout(new GridBagLayout());
        this.GeneralPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.jLabel4.setText("Cut Name");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.anchor = 13;
        this.GeneralPanel.add((Component)this.jLabel4, gridBagConstraints2);
        this.expressionName.setColumns(15);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        this.GeneralPanel.add((Component)this.expressionName, gridBagConstraints2);
        this.jLabel5.setText("Expression");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.anchor = 13;
        this.GeneralPanel.add((Component)this.jLabel5, gridBagConstraints2);
        this.expression.setToolTipText("Enter boolean expression");
        this.expression.setNTuple(this.tuple);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        this.GeneralPanel.add((Component)this.expression, gridBagConstraints2);
        this.jTabbedPane1.addTab("General Cut", this.GeneralPanel);
        this.cutSetPanel.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel3.setText("Cut Name: ");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints3);
        this.cutSetName.setColumns(10);
        this.cutSetName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddCutDialog.this.cutSetNameActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        this.jPanel2.add((Component)this.cutSetName, gridBagConstraints3);
        this.add.setToolTipText("Add existing cut to cut set");
        this.add.setMnemonic('A');
        this.add.setText("Add...");
        this.add.setEnabled(false);
        gridBagConstraints3 = new GridBagConstraints();
        this.jPanel2.add((Component)this.add, gridBagConstraints3);
        this.remove.setToolTipText("Remove selected cuts from cut set");
        this.remove.setMnemonic('R');
        this.remove.setText("Remove");
        this.remove.setEnabled(false);
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddCutDialog.this.removeActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        this.jPanel2.add((Component)this.remove, gridBagConstraints3);
        this.newCut.setToolTipText("Add new cut to cut set");
        this.newCut.setMnemonic('N');
        this.newCut.setText("New...");
        this.newCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddCutDialog.this.newCutActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        this.jPanel2.add((Component)this.newCut, gridBagConstraints3);
        this.cutSetPanel.add((Component)this.jPanel2, "North");
        this.jTable1.setModel(new CutSetTable(this.temp));
        this.jTable1.setPreferredScrollableViewportSize(new Dimension(250, 100));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.cutSetPanel.add((Component)this.jScrollPane1, "Center");
        this.jTabbedPane1.addTab("Cut Set", this.cutSetPanel);
        this.getContentPane().add((Component)this.jTabbedPane1, "North");
        this.pack();
    }

    private void removeActionPerformed(ActionEvent evt) {
    }

    private void newCutActionPerformed(ActionEvent evt) {
        AddCutDialog dlg = new AddCutDialog((Dialog)this, this.tt);
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.show();
        NTupleCut cut = dlg.getCut();
        if (cut != null) {
            this.temp.addCut(cut);
        }
    }

    private void cutSetNameActionPerformed(ActionEvent evt) {
    }

    private void columnActionPerformed(ActionEvent evt) {
        this.columnCheckbox.setSelected(true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedIndex() == 0) {
                String colName = this.cutName.getText();
                if (this.tuple.getColumnByName(colName) != null) {
                    JOptionPane.showMessageDialog(this, "Cut name already in use", "Error", 0);
                } else {
                    NTupleColumn col;
                    if (this.columnCheckbox.isSelected()) {
                        col = (NTupleColumn)this.column.getSelectedItem();
                    } else {
                        CompiledExpression c = this.numericExpression.compile(Double.TYPE);
                        col = new JELColumn(this.tuple, colName, this.numericExpression.getText(), c);
                    }
                    int type = this.cutType.getSelectedIndex();
                    this.cut = new NumericCut1D(colName, col, type);
                    this.tt.addCut(this.cut);
                    this.dispose();
                }
            } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
                String colName = this.expressionName.getText();
                if (this.tuple.getColumnByName(colName) != null) {
                    JOptionPane.showMessageDialog(this, "Cut name already in use", "Error", 0);
                }
                CompiledExpression c = this.expression.compile(Boolean.TYPE);
                this.cut = new JELCut(colName, this.tuple, c, this.expression.getText());
                this.tt.addCut(this.cut);
                this.dispose();
            } else {
                String cutName = this.cutSetName.getText();
                CutSet cs = new CutSet(cutName);
                int i = 0;
                while (i < this.temp.getNCuts()) {
                    cs.addCut(this.temp.getCut(i));
                    ++i;
                }
                this.tt.addCut(cs);
                this.dispose();
            }
        }
        catch (CompilationException x) {
            String message = x.getMessage();
            JOptionPane.showMessageDialog(this, (Object)x, "Compilation Error", 0);
        }
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public NTupleCut getCut() {
        return this.cut;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

