/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple;

import jas.tuple.CutColumn;
import jas.tuple.MutableNTuple;
import jas.tuple.NTupleCursor;
import jas.tuple.NTupleCut;
import jas.tuple.Plot;
import jas.tuple.PlotSet;
import jas.tuple.cut.CutSet;
import javax.swing.SwingUtilities;

public class TreeTuple
implements Runnable {
    private MutableNTuple tuple;
    private CutSet allCuts;
    private CutSet defaultCuts;
    private PlotSet plots;
    private boolean valid;

    public TreeTuple(MutableNTuple tuple) {
        this.tuple = tuple;
        this.allCuts = new CutSet("allCuts");
        this.defaultCuts = new CutSet("defaultCuts");
        this.plots = new PlotSet();
    }

    public MutableNTuple getNTuple() {
        return this.tuple;
    }

    public CutSet allCuts() {
        return this.allCuts;
    }

    public CutSet defaultCuts() {
        return this.defaultCuts;
    }

    public PlotSet plots() {
        return this.plots;
    }

    public void addCut(NTupleCut cut) {
        this.allCuts.addCut(cut);
        this.tuple.addColumn(new CutColumn(cut));
    }

    public void runLater() {
        if (this.valid) {
            SwingUtilities.invokeLater(this);
        }
        this.valid = false;
    }

    public void run() {
        int i;
        this.valid = true;
        int n = this.plots.getNPlots();
        Plot[] plot = new Plot[n];
        int j = 0;
        int i2 = 0;
        while (i2 < n) {
            Plot p = this.plots.getPlot(i2);
            if (p.isOutOfDate()) {
                plot[j++] = p;
                p.start();
            }
            ++i2;
        }
        System.out.println(j + "Out of date plots");
        NTupleCursor cursor = this.tuple.getCursor();
        while (cursor.nextRow()) {
            i = 0;
            while (i < j) {
                plot[i].fill(cursor);
                ++i;
            }
        }
        i = 0;
        while (i < j) {
            plot[i].end();
            ++i;
        }
    }
}

