/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple;

import jas.tuple.CutChangedEvent;
import jas.tuple.CutListener;
import jas.tuple.NTupleCursor;
import jas.tuple.Projection;
import jas.tuple.TreeTuple;
import jas.tuple.cut.CutSet;
import java.io.Serializable;

public class Plot
implements CutListener,
Serializable {
    private Projection project;
    private CutSet cuts;
    private String name;
    private TreeTuple tuple;
    private boolean isOutOfDate = true;

    public Plot(String name, Projection project, CutSet cuts, TreeTuple tuple) {
        this.name = name;
        this.project = project;
        this.cuts = cuts;
        this.tuple = tuple;
        cuts.addCutListener(this);
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        this.isOutOfDate = false;
        this.project.start();
    }

    public void end() {
        this.project.end();
    }

    public void fill(NTupleCursor cursor) {
        if (this.cuts.accept(cursor)) {
            this.project.fill(cursor);
        }
    }

    public boolean isOutOfDate() {
        return this.isOutOfDate;
    }

    public void invalidate() {
        this.isOutOfDate = true;
    }

    public void cutChanged(CutChangedEvent e) {
        this.invalidate();
        this.tuple.runLater();
    }

    public CutSet getCuts() {
        return this.cuts;
    }

    public TreeTuple getTuple() {
        return this.tuple;
    }

    public Projection getProjection() {
        return this.project;
    }
}

