/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple;

import jas.tuple.NTuple;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class NTupleTableModel
extends AbstractTableModel {
    private NTuple source;
    private List selectedColumns;

    public NTupleTableModel(NTuple source) {
        this(source, null);
    }

    public NTupleTableModel(NTuple source, List selectedColumns) {
        if (!source.supportsRandomAccess()) {
            throw new IllegalArgumentException("NTuple does not support random access");
        }
        if (source.getNRows() == -1) {
            throw new IllegalArgumentException("NTuple does not have well defined number of rows");
        }
        this.source = source;
        this.selectedColumns = selectedColumns;
    }

    public Object getValueAt(int row, int column) {
        try {
            NTupleCursor cursor = this.source.getCursor();
            cursor.setRow(row);
            if (this.selectedColumns == null) {
                return this.source.getColumn(column).getValue(cursor);
            }
            return ((NTupleColumn)this.selectedColumns.get(column)).getValue(cursor);
        }
        catch (IllegalStateException x) {
            return null;
        }
    }

    public int getRowCount() {
        return this.source.getNRows();
    }

    public int getColumnCount() {
        return this.selectedColumns == null ? this.source.getNColumns() : this.selectedColumns.size();
    }

    public String getColumnName(int column) {
        if (this.selectedColumns == null) {
            return this.source.getColumn(column).getName();
        }
        return ((NTupleColumn)this.selectedColumns.get(column)).getName();
    }
}

