/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple;

import hep.analysis.EndOfDataException;
import hep.analysis.EventSource;
import hep.analysis.NTupleEventData;
import jas.jds.module.AnnotatedEventSource;
import jas.tuple.NTuple;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.Value;
import jas.util.tree.TreeItem;
import java.util.HashMap;

public class JASNTupleAdapter
implements NTuple {
    private EventSource source;
    private CursorAdapter theCursor;
    private HashMap hash;
    private NTupleColumn[] column;
    private NTupleEventData event;
    static /* synthetic */ Class class$hep$analysis$NTupleEventData;

    public JASNTupleAdapter(AnnotatedEventSource source) {
        this((EventSource)source, source.getItems());
    }

    public JASNTupleAdapter(EventSource source, TreeItem[] items) {
        if (!(class$hep$analysis$NTupleEventData == null ? (class$hep$analysis$NTupleEventData = JASNTupleAdapter.class$("hep.analysis.NTupleEventData")) : class$hep$analysis$NTupleEventData).isAssignableFrom(source.getEventDataClass())) {
            throw new IllegalArgumentException("Not an ntuple");
        }
        this.source = source;
        this.hash = new HashMap();
        this.column = new NTupleColumn[items.length];
        int i = 0;
        while (i < items.length) {
            String name = items[i].path[items[i].path.length - 1];
            this.column[i] = new ColumnAdapter(i, name, items[i].type);
            ++i;
        }
    }

    public String getTitle() {
        return this.source.getName();
    }

    public int getNColumns() {
        return this.column.length;
    }

    public int getNRows() {
        return this.source.getTotalNumberOfEvents();
    }

    public NTupleColumn getColumn(int n) {
        return this.column[n];
    }

    public NTupleColumn getColumnByName(String name) {
        return (NTupleColumn)this.hash.get(name);
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    public boolean supportsMultipleCursors() {
        return false;
    }

    public NTupleCursor getCursor() throws IllegalStateException {
        if (this.theCursor == null) {
            return new CursorAdapter();
        }
        throw new IllegalStateException("Multiple cursors not supported");
    }

    public void close() {
        this.source.close();
    }

    public int indexForColumnName(String name) {
        ColumnAdapter col = (ColumnAdapter)this.hash.get(name);
        if (col == null) {
            throw new IllegalArgumentException("Column " + name + " not found");
        }
        return col.getColumnIndex();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ColumnAdapter
    implements NTupleColumn {
        private String name;
        private Class type;
        private int column;
        private Value value = new Value();
        static /* synthetic */ Class class$java$lang$Object;

        ColumnAdapter(int column, String name, String typeName) {
            this.column = column;
            this.name = name;
            this.type = typeName.equals("float") ? Value.TYPE_DOUBLE : (typeName.equals("integer") ? Value.TYPE_INTEGER : (typeName.equals("string") ? Value.TYPE_STRING : (typeName.equals("date") ? Value.TYPE_DATE : (typeName.equals("time") ? Value.TYPE_DATE : (typeName.equals("boolean") ? Value.TYPE_BOOLEAN : (class$java$lang$Object == null ? (class$java$lang$Object = ColumnAdapter.class$("java.lang.Object")) : class$java$lang$Object))))));
        }

        public String getName() {
            return this.name;
        }

        public Class getType() {
            return this.type;
        }

        public Value getMinValue() {
            throw new UnsupportedOperationException();
        }

        public Value getMaxValue() {
            throw new UnsupportedOperationException();
        }

        public Value getValue(NTupleCursor cursor) {
            if (this.type == Value.TYPE_DOUBLE) {
                return this.value.set(JASNTupleAdapter.this.event.getDouble(this.column));
            }
            if (this.type == Value.TYPE_INTEGER) {
                return this.value.set(JASNTupleAdapter.this.event.getInt(this.column));
            }
            if (this.type == Value.TYPE_STRING) {
                return this.value.set(JASNTupleAdapter.this.event.getString(this.column));
            }
            if (this.type == Value.TYPE_DATE) {
                return this.value.set(JASNTupleAdapter.this.event.getDate(this.column));
            }
            if (this.type == Value.TYPE_BOOLEAN) {
                return this.value.set(JASNTupleAdapter.this.event.getBoolean(this.column));
            }
            return this.value.set(JASNTupleAdapter.this.event.getObject(this.column));
        }

        int getColumnIndex() {
            return this.column;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class CursorAdapter
    implements NTupleCursor {
        private int row;

        CursorAdapter() {
            JASNTupleAdapter.this.source.beforeFirstEvent();
            this.row = -1;
        }

        public void close() {
            JASNTupleAdapter.this.theCursor = null;
        }

        public void rewind() {
            JASNTupleAdapter.this.source.beforeFirstEvent();
            this.row = -1;
        }

        public boolean nextRow() {
            try {
                JASNTupleAdapter.this.event = (NTupleEventData)JASNTupleAdapter.this.source.getNextEvent();
                ++this.row;
                return true;
            }
            catch (EndOfDataException x) {
                return false;
            }
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int n) {
            throw new UnsupportedOperationException("Random access not supported");
        }
    }
}

