/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple;

import jas.tuple.InMemoryNTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.Value;

class InMemoryNTupleColumnInt
extends InMemoryNTupleColumn {
    private Value value = new Value();
    private int[] data;
    private int min = 0;
    private int max = 0;

    public InMemoryNTupleColumnInt(String name, int index, int size) {
        super(name, Value.TYPE_INTEGER, index);
        this.data = new int[size == -1 ? 1000 : size];
    }

    void setValue(int row, Value value) {
        int i;
        if (row >= this.data.length) {
            int oldSize = this.data.length;
            int newSize = row + 1000;
            int[] newData = new int[newSize];
            System.arraycopy(this.data, 0, newData, 0, oldSize);
            this.data = newData;
        }
        this.data[row] = i = value.getInt();
        if (row == 0) {
            this.min = this.max = i;
        } else {
            if (this.min > i) {
                this.min = i;
            }
            if (this.max < i) {
                this.max = i;
            }
        }
    }

    public Value getValue(NTupleCursor cursor) {
        return this.value.set(this.data[cursor.getRow()]);
    }

    public Value getMaxValue() {
        return this.value.set(this.max);
    }

    public Value getMinValue() {
        return this.value.set(this.min);
    }
}

