/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple;

import jas.tuple.InMemoryNTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.Value;

class InMemoryNTupleColumnDouble
extends InMemoryNTupleColumn {
    private Value value = new Value();
    private double[] data;
    private double min = Double.NaN;
    private double max = Double.NaN;

    public InMemoryNTupleColumnDouble(String name, int index, int size) {
        super(name, Value.TYPE_DOUBLE, index);
        this.data = new double[size == -1 ? 1000 : size];
    }

    void setValue(int row, Value value) {
        double d;
        if (row >= this.data.length) {
            int oldSize = this.data.length;
            int newSize = row + 1000;
            double[] newData = new double[newSize];
            System.arraycopy(this.data, 0, newData, 0, oldSize);
            this.data = newData;
        }
        this.data[row] = d = value.getDouble();
        if (Double.isNaN(this.min) || this.min > d) {
            this.min = d;
        }
        if (Double.isNaN(this.max) || this.max < d) {
            this.max = d;
        }
    }

    public Value getValue(NTupleCursor cursor) {
        return this.value.set(this.data[cursor.getRow()]);
    }

    public Value getMaxValue() {
        return this.value.set(this.max);
    }

    public Value getMinValue() {
        return this.value.set(this.min);
    }
}

