/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple;

import jas.tuple.InMemoryNTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.Value;
import java.util.Date;

class InMemoryNTupleColumnDate
extends InMemoryNTupleColumn {
    private Value value = new Value();
    private Value nullValue = new Value();
    private Date date = new Date();
    private long[] data;
    private long min = -1L;
    private long max = -1L;

    public InMemoryNTupleColumnDate(String name, int index, int size) {
        super(name, Value.TYPE_DATE, index);
        this.data = new long[size == -1 ? 1000 : size];
        this.value.set(this.date);
        this.nullValue.set((Date)null);
    }

    void setValue(int row, Value value) {
        Date dd;
        long d;
        if (row >= this.data.length) {
            int oldSize = this.data.length;
            int newSize = row + 1000;
            long[] newData = new long[newSize];
            System.arraycopy(this.data, 0, newData, 0, oldSize);
            this.data = newData;
        }
        this.data[row] = d = (dd = value.getDate()) == null ? -1L : dd.getTime();
        if (d >= 0L) {
            if (this.min < 0L) {
                this.min = this.max = d;
            } else {
                if (this.min > d) {
                    this.min = d;
                }
                if (this.max < d) {
                    this.max = d;
                }
            }
        }
    }

    public Value getValue(NTupleCursor cursor) {
        long d = this.data[cursor.getRow()];
        if (d < 0L) {
            return this.nullValue;
        }
        this.date.setTime(d);
        return this.value;
    }

    public Value getMaxValue() {
        this.date.setTime(this.max);
        return this.value;
    }

    public Value getMinValue() {
        this.date.setTime(this.min);
        return this.value;
    }
}

