/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple;

import jas.tuple.InMemoryNTupleColumn;
import jas.tuple.InMemoryNTupleColumnDate;
import jas.tuple.InMemoryNTupleColumnDouble;
import jas.tuple.InMemoryNTupleColumnInt;
import jas.tuple.InMemoryNTupleColumnObject;
import jas.tuple.MutableNTuple;
import jas.tuple.NTuple;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.NTupleEvent;
import jas.tuple.NTupleListener;
import jas.tuple.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class InMemoryNTuple
implements MutableNTuple {
    private String title;
    private int nRows;
    private List columns;
    private Map hash;
    private EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$jas$tuple$NTupleListener;

    public InMemoryNTuple(NTuple source) {
        this.title = source.getTitle();
        int nColumns = source.getNColumns();
        InMemoryNTupleColumn[] column = new InMemoryNTupleColumn[nColumns];
        this.hash = new HashMap(nColumns);
        this.nRows = source.getNRows();
        int i = 0;
        while (i < nColumns) {
            NTupleColumn sourceColumn = source.getColumn(i);
            Class type = sourceColumn.getType();
            String name = sourceColumn.getName();
            column[i] = type == Value.TYPE_DOUBLE ? new InMemoryNTupleColumnDouble(name, this.nRows, i) : (type == Value.TYPE_INTEGER ? new InMemoryNTupleColumnInt(name, this.nRows, i) : (type == Value.TYPE_DATE ? new InMemoryNTupleColumnDate(name, this.nRows, i) : new InMemoryNTupleColumnObject(name, type, i, this.nRows)));
            this.hash.put(name, column[i]);
            ++i;
        }
        NTupleCursor cursor = source.getCursor();
        int row = 0;
        while (cursor.nextRow()) {
            int i2 = 0;
            while (i2 < nColumns) {
                NTupleColumn sourceColumn = source.getColumn(i2);
                column[i2].setValue(row, sourceColumn.getValue(cursor));
                ++i2;
            }
            ++row;
        }
        this.nRows = row;
        this.columns = new ArrayList(nColumns);
        int i3 = 0;
        while (i3 < nColumns) {
            this.columns.add(column[i3]);
            ++i3;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public int getNColumns() {
        return this.columns.size();
    }

    public int getNRows() {
        return this.nRows;
    }

    public NTupleColumn getColumn(int n) {
        return (NTupleColumn)this.columns.get(n);
    }

    public NTupleColumn getColumnByName(String name) {
        return (NTupleColumn)this.hash.get(name);
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public NTupleCursor getCursor() throws IllegalStateException {
        return new InMemoryCursor();
    }

    public void close() {
    }

    public int indexForColumnName(String name) {
        NTupleColumn col = (NTupleColumn)this.hash.get(name);
        if (col == null) {
            throw new IllegalArgumentException("Column " + name + " not found");
        }
        if (col instanceof InMemoryNTupleColumn) {
            return ((InMemoryNTupleColumn)col).getColumnIndex();
        }
        return this.columns.indexOf(col);
    }

    public void addColumn(NTupleColumn column) {
        int index = this.columns.size();
        this.columns.add(column);
        this.hash.put(column.getName(), column);
        this.fireColumnsAdded(index, index);
    }

    private void fireColumnsAdded(int first, int last) {
        if (this.listeners.getListenerCount(class$jas$tuple$NTupleListener == null ? (class$jas$tuple$NTupleListener = InMemoryNTuple.class$("jas.tuple.NTupleListener")) : class$jas$tuple$NTupleListener) == 0) {
            return;
        }
        NTupleEvent e = new NTupleEvent(this);
        e.setRange(first, last);
        NTupleListener[] l = (NTupleListener[])this.listeners.getListeners(class$jas$tuple$NTupleListener == null ? (class$jas$tuple$NTupleListener = InMemoryNTuple.class$("jas.tuple.NTupleListener")) : class$jas$tuple$NTupleListener);
        int i = 0;
        while (i < l.length) {
            l[i].columnsAdded(e);
            ++i;
        }
    }

    public void removeNTupleListener(NTupleListener l) {
        this.listeners.remove(class$jas$tuple$NTupleListener == null ? (class$jas$tuple$NTupleListener = InMemoryNTuple.class$("jas.tuple.NTupleListener")) : class$jas$tuple$NTupleListener, l);
    }

    public void addNTupleListener(NTupleListener l) {
        this.listeners.add(class$jas$tuple$NTupleListener == null ? (class$jas$tuple$NTupleListener = InMemoryNTuple.class$("jas.tuple.NTupleListener")) : class$jas$tuple$NTupleListener, l);
    }

    public void removeColumn(NTupleColumn column) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class InMemoryCursor
    implements NTupleCursor {
        private int row = -1;

        InMemoryCursor() {
        }

        public void rewind() {
            this.row = -1;
        }

        public boolean nextRow() {
            return ++this.row < InMemoryNTuple.this.nRows;
        }

        public void setRow(int n) throws IndexOutOfBoundsException, UnsupportedOperationException {
            if (n < 0 || n >= InMemoryNTuple.this.nRows) {
                throw new IndexOutOfBoundsException();
            }
            this.row = n;
        }

        public void close() {
        }

        public int getRow() {
            return this.row;
        }
    }
}

