/*
 * Decompiled with CFR 0.152.
 */
package jas.tuple;

import jas.tuple.MutableNTuple;
import jas.tuple.NTuple;
import jas.tuple.NTupleColumn;
import jas.tuple.NTupleCursor;
import jas.tuple.NTupleEvent;
import jas.tuple.NTupleListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class DerivedNTuple
implements MutableNTuple {
    private NTuple source;
    private List extraColumns = new LinkedList();
    private Map hash = new HashMap();
    private String title;
    private EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$jas$tuple$NTupleListener;

    public DerivedNTuple(NTuple source, String title) {
        this.source = source;
        this.title = title;
    }

    public String getTitle() {
        return this.title == null ? this.source.getTitle() : this.title;
    }

    public void close() {
        this.source.close();
    }

    public int getNRows() {
        return this.source.getNRows();
    }

    public int getNColumns() {
        return this.source.getNColumns() + this.extraColumns.size();
    }

    public int indexForColumnName(String name) {
        NTupleColumn col = (NTupleColumn)this.hash.get(name);
        if (col != null) {
            return this.extraColumns.indexOf(col);
        }
        return this.source.indexForColumnName(name);
    }

    public boolean supportsRandomAccess() {
        return this.source.supportsRandomAccess();
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public NTupleColumn getColumnByName(String name) {
        NTupleColumn col = (NTupleColumn)this.hash.get(name);
        if (col != null) {
            return col;
        }
        return this.source.getColumnByName(name);
    }

    public NTupleColumn getColumn(int n) {
        int l = this.source.getNColumns();
        if (n < l) {
            return this.source.getColumn(n);
        }
        return (NTupleColumn)this.extraColumns.get(n - l);
    }

    public void removeNTupleListener(NTupleListener l) {
        this.listeners.remove(class$jas$tuple$NTupleListener == null ? (class$jas$tuple$NTupleListener = DerivedNTuple.class$("jas.tuple.NTupleListener")) : class$jas$tuple$NTupleListener, l);
    }

    public void addNTupleListener(NTupleListener l) {
        this.listeners.add(class$jas$tuple$NTupleListener == null ? (class$jas$tuple$NTupleListener = DerivedNTuple.class$("jas.tuple.NTupleListener")) : class$jas$tuple$NTupleListener, l);
    }

    public void addColumn(NTupleColumn column) {
        int index = this.extraColumns.size() + this.source.getNColumns();
        this.extraColumns.add(column);
        this.hash.put(column.getName(), column);
        this.fireColumnsAdded(index, index);
    }

    public void removeColumn(NTupleColumn column) {
    }

    private void fireColumnsAdded(int first, int last) {
        if (this.listeners.getListenerCount(class$jas$tuple$NTupleListener == null ? (class$jas$tuple$NTupleListener = DerivedNTuple.class$("jas.tuple.NTupleListener")) : class$jas$tuple$NTupleListener) == 0) {
            return;
        }
        NTupleEvent e = new NTupleEvent(this);
        e.setRange(first, last);
        NTupleListener[] l = (NTupleListener[])this.listeners.getListeners(class$jas$tuple$NTupleListener == null ? (class$jas$tuple$NTupleListener = DerivedNTuple.class$("jas.tuple.NTupleListener")) : class$jas$tuple$NTupleListener);
        int i = 0;
        while (i < l.length) {
            l[i].columnsAdded(e);
            ++i;
        }
    }

    public NTupleCursor getCursor() throws IllegalStateException {
        return this.source.getCursor();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

