/*
 * Decompiled with CFR 0.152.
 */
package jasext.paw;

import jas.hist.Statistics;
import jasext.paw.CompositeHObj;
import jasext.paw.FieldHObj;
import jasext.paw.Hbook;
import jasext.paw.RowwiseTuple;

class RowwiseTupleField
extends FieldHObj {
    private int column;
    private double min;
    private double max;

    public RowwiseTupleField(CompositeHObj compositeHObj, String string, int n, float f, float f2) {
        super(compositeHObj, string, 1);
        this.min = f;
        this.max = f2;
        this.column = n;
    }

    double getDouble(long l) {
        return Hbook.getRWData(l, this.column);
    }

    String getJASType() {
        return "float";
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        RowwiseTuple rowwiseTuple = (RowwiseTuple)this.getParent();
        int n2 = rowwiseTuple.getID();
        double[] dArray = Hbook.RWrebin(n2, this.column, rowwiseTuple.nChildren(), n, d, d2);
        double[][] dArrayArray = new double[][]{dArray};
        return dArrayArray;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.name;
    }

    public boolean isRebinnable() {
        return true;
    }

    public int getBins() {
        return 40;
    }

    public int getAxisType() {
        return 1;
    }

    public String toString() {
        String string = "RW Tuple Field: (" + this.getJASType() + ") " + this.name + " (min=" + this.min + " max=" + this.max + ")";
        return string;
    }

    public Statistics getStatistics() {
        return null;
    }
}

