/*
 * Decompiled with CFR 0.152.
 */
package jasext.paw;

import hep.analysis.AbstractNTupleEventData;
import hep.analysis.EndOfDataException;
import hep.analysis.EventData;
import hep.analysis.EventDataException;
import hep.analysis.NTupleEventData;
import jasext.paw.CompositeHObj;
import jasext.paw.Hbook;
import jasext.paw.RowwiseTupleField;
import jasext.paw.TupleHObj;

class RowwiseTuple
extends TupleHObj {
    private int id;
    private long buffer = 0L;

    RowwiseTuple(CompositeHObj compositeHObj, String string, int n, int n2) {
        super(compositeHObj, string, 2, n);
        this.setEventData((NTupleEventData)new RowwiseEventData());
        this.id = n2;
    }

    public EventData getNextEvent() throws EndOfDataException {
        if (this.buffer == 0L) {
            this.buffer = Hbook.allocBuffer(4 * this.nChildren());
        }
        EventData eventData = super.getNextEvent();
        Hbook.setRWEvent(this.id, this.ievent, this.buffer);
        return eventData;
    }

    int getID() {
        return this.id;
    }

    public String toString() {
        String string = "RW Tuple: " + this.name + " (" + this.nChildren() + " columns " + this.getTotalNumberOfEvents() + " rows)";
        return string;
    }

    public void close() {
        super.close();
        if (this.buffer != 0L) {
            Hbook.freeBuffer(this.buffer);
        }
        Hbook.delete(this.id);
    }

    private final class RowwiseEventData
    extends AbstractNTupleEventData {
        private RowwiseEventData() {
        }

        public double getDouble(String string) {
            RowwiseTupleField rowwiseTupleField = (RowwiseTupleField)RowwiseTuple.this.getChild(string);
            if (rowwiseTupleField == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return rowwiseTupleField.getDouble(RowwiseTuple.this.buffer);
        }

        public double getDouble(int n) {
            RowwiseTupleField rowwiseTupleField = (RowwiseTupleField)RowwiseTuple.this.getChild(n);
            if (rowwiseTupleField == null) {
                throw new EventDataException("Can not find column " + n);
            }
            return rowwiseTupleField.getDouble(RowwiseTuple.this.buffer);
        }

        public int findColumn(String string) {
            return RowwiseTuple.this.getIndex(string);
        }
    }
}

