/*
 * Decompiled with CFR 0.152.
 */
package jasext.paw;

import hep.analysis.EndOfDataException;
import hep.analysis.EventData;
import jas.jds.module.AnnotatedEventSource;
import jas.jds.module.ModuleException;
import jas.util.tree.TreeItem;
import jasext.paw.CompositeHObj;
import jasext.paw.FieldHObj;
import jasext.paw.HObj;
import jasext.paw.Hbook;
import jasext.paw.HbookFileHObj;
import jasext.paw.TupleHObj;
import java.util.Enumeration;
import java.util.Vector;

public class PawEventSource
implements AnnotatedEventSource {
    private String fileName;
    private HbookFileHObj root;
    static /* synthetic */ Class class$hep$analysis$EventData;

    public PawEventSource(String string) throws ModuleException {
        this.fileName = string;
        this.root = Hbook.openFile(string);
    }

    public void close() {
        if (this.root != null) {
            this.root.close();
            this.root = null;
        }
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        int n = this.fileName.lastIndexOf(System.getProperty("file.separator"));
        return this.fileName.substring(n + 1);
    }

    public TreeItem[] getItems() {
        Vector vector = new Vector();
        this.buildTreeItemList(this.root, 0, vector);
        Object[] objectArray = new TreeItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object getItem(TreeItem treeItem) {
        HObj hObj = this.findItem(treeItem);
        if (hObj instanceof FieldHObj) {
            return ((FieldHObj)hObj).getRebinnable1DHistogramData();
        }
        return hObj;
    }

    public int getTotalNumberOfEvents() {
        return 0;
    }

    public void beforeFirstEvent() {
    }

    public void afterLastEvent() {
    }

    public EventData getNextEvent() throws EndOfDataException {
        throw new EndOfDataException();
    }

    public Class getEventDataClass() {
        return class$hep$analysis$EventData == null ? (class$hep$analysis$EventData = PawEventSource.class$("hep.analysis.EventData")) : class$hep$analysis$EventData;
    }

    public static void main(String[] stringArray) throws Exception {
        PawEventSource pawEventSource = new PawEventSource(stringArray[0]);
    }

    private void buildTreeItemList(CompositeHObj compositeHObj, int n, Vector vector) {
        Enumeration enumeration = compositeHObj.getChildren();
        while (enumeration.hasMoreElements()) {
            HObj hObj = (HObj)enumeration.nextElement();
            if (hObj instanceof CompositeHObj) {
                if (hObj instanceof TupleHObj) {
                    vector.addElement(hObj.getTreeItem(n));
                }
                this.buildTreeItemList((CompositeHObj)hObj, n + 1, vector);
                continue;
            }
            vector.addElement(hObj.getTreeItem(n));
        }
    }

    private HObj findItem(TreeItem treeItem) {
        HObj hObj = this.root;
        int n = 0;
        while (n < treeItem.path.length) {
            hObj = ((CompositeHObj)hObj).getChild(treeItem.path[n]);
            ++n;
        }
        return hObj;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

