/*
 * Decompiled with CFR 0.152.
 */
package jasext.paw;

import jas.jds.module.ModuleException;
import jasext.paw.CompositeHObj;
import jasext.paw.HObj;
import jasext.paw.HbookFileHObj;
import jasext.paw.PawException;
import java.io.File;

abstract class Hbook {
    private static boolean init = false;
    private static boolean[] luns;

    Hbook() {
    }

    static synchronized HbookFileHObj openFile(String string) throws ModuleException {
        if (!init) {
            Hbook.doInit();
        }
        if (File.pathSeparatorChar == ':' && File.separatorChar == '/' && !string.toLowerCase().equals(string)) {
            throw new PawException("CERNLIB requires PAW file names be all lowercase under Unix. Please complain to Rene Brun!");
        }
        CompositeHObj compositeHObj = Hbook.openFile(string, Hbook.getLun());
        if (compositeHObj == null) {
            throw new PawException("Could not open " + string);
        }
        return (HbookFileHObj)compositeHObj;
    }

    static synchronized void close(String string, int n) {
        Hbook.closeFile(string, n);
        Hbook.freeLun(n);
    }

    private static native CompositeHObj openFile(String var0, int var1);

    private static native void closeFile(String var0, int var1);

    static synchronized native int visitChildren(HObj var0);

    static native void init();

    static synchronized native void setCWEvent(int var0, int var1);

    static synchronized native void setRWEvent(int var0, int var1, long var2);

    static native double getRWData(long var0, int var2);

    static native double getCWDataDouble(long var0, int var2, int var3);

    static native int getCWDataInt(long var0, int var2, int var3);

    static native long getCWDataLong(long var0, int var2, int var3);

    static native String getCWDataString(long var0, int var2, int var3);

    static boolean getCWDataBoolean(long l, int n, int n2) {
        return Hbook.getCWDataInt(l, n, n2) != 0;
    }

    static native double[] RWrebin(int var0, int var1, int var2, int var3, double var4, double var6);

    static native double[] CWgetMinMax(int var0, long var1, int var3, int var4, int var5, int var6, int var7);

    static native double[] CWrebin(int var0, long var1, int var3, int var4, int var5, int var6, int var7, int var8, double var9, double var11);

    static synchronized native long allocBuffer(int var0);

    static synchronized native void freeBuffer(long var0);

    static native void CWClearMap(int var0, String var1, long var2);

    static native void CWMap(int var0, String var1, long var2, String var4, int var5, int var6);

    static native double[] Hist1DData(int var0, int var1);

    static native double[] Hist1DErrors(int var0, int var1);

    static native double[][] Hist2DData(int var0, int var1, int var2);

    static native double[][] Hist2DErrors(int var0, int var1, int var2);

    static synchronized native void delete(int var0);

    private static synchronized int getLun() {
        int n = 10;
        while (n < luns.length) {
            if (luns[n]) {
                Hbook.luns[n] = false;
                return n;
            }
            ++n;
        }
        throw new RuntimeException("No free luns");
    }

    private static synchronized void freeLun(int n) {
        Hbook.luns[n] = true;
    }

    private static void doInit() throws ModuleException {
        String string = "hbook";
        try {
            System.out.println("Loading " + string + " ...");
            System.loadLibrary(string);
            Hbook.init();
            luns = new boolean[100];
            int n = 0;
            while (n < luns.length) {
                Hbook.luns[n] = true;
                ++n;
            }
            init = true;
        }
        catch (Throwable throwable) {
            throw new ModuleException("Error loading native library: " + string, throwable);
        }
    }
}

