/*
 * Decompiled with CFR 0.152.
 */
package jasext.paw;

import hep.analysis.EventDataException;
import hep.analysis.Partition;
import hep.analysis.partition.StringPartition;
import jas.hep.PartitionAdapter;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;
import jasext.paw.ColumnwiseBlock;
import jasext.paw.ColumnwiseTuple;
import jasext.paw.FieldHObj;
import jasext.paw.Hbook;
import jasext.paw.PawArray;
import jasext.paw.PawBooleanArray;
import jasext.paw.PawDoubleArray;
import jasext.paw.PawIntegerArray;
import jasext.paw.PawStringArray;
import java.util.StringTokenizer;

class ColumnwiseTupleField
extends FieldHObj {
    private PawArray array;
    private String full;
    private ColumnwiseBlock block;
    private int nsub;
    private int size;
    private int elem;
    int offset;
    private int[] dimension;
    private int column;
    private int fixed;
    ColumnwiseTupleField index;
    private double min = 0.0;
    private double max = 0.0;
    private boolean minMaxKnown = false;
    boolean isMapped = false;
    private static final String[] types = new String[]{"", "float", "integer", "integer", "boolean", "string"};
    private static final String[] arrayTypes = new String[]{"", "jasext.paw.PawDoubleArray", "jasext.paw.PawIntegerArray", "jasext.paw.PawIntegerArray", "jasext.paw.PawBooleanArray", "jasext.paw.PawStringArray"};

    public ColumnwiseTupleField(ColumnwiseTuple columnwiseTuple, String string, String string2, String string3, int n, int n2, int n3, int n4, int n5) {
        super(columnwiseTuple, string, n3);
        this.column = n;
        this.full = string2;
        this.nsub = n2;
        this.size = n4;
        this.elem = n5;
        this.block = columnwiseTuple.getBlock(string3);
        this.offset = this.block.allocSpace(this, n4 * n5);
        this.fixed = 1;
        if (n2 > 0) {
            this.dimension = new int[n2];
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[]", false);
            stringTokenizer.nextToken();
            int n6 = 0;
            while (n6 < n2) {
                String string4 = stringTokenizer.nextToken();
                if (string4 == null) {
                    throw new RuntimeException("Paw columnwise tuple parse failure " + string2);
                }
                try {
                    this.dimension[n6] = Integer.parseInt(string4);
                    this.fixed *= this.dimension[n6];
                }
                catch (NumberFormatException numberFormatException) {
                    ColumnwiseTuple columnwiseTuple2 = (ColumnwiseTuple)this.getParent();
                    ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)columnwiseTuple.getChild(string4);
                    if (columnwiseTupleField == null) {
                        throw new RuntimeException("Paw columnwise tuple parse failure " + string2);
                    }
                    this.dimension[n6] = -columnwiseTupleField.column;
                    this.index = columnwiseTupleField;
                }
                ++n6;
            }
        }
    }

    public String toString() {
        String string = "CW Tuple Field: (" + this.getJASType() + ") " + this.full;
        if (this.minMaxKnown) {
            string = string + " (min=" + this.min + " max=" + this.max + ")";
        }
        return string;
    }

    double getDouble() {
        if (this.type == 2 || this.type == 3) {
            return this.getInt();
        }
        if (this.type != 1) {
            throw new EventDataException("getDouble called for non-float data: " + this.name);
        }
        if (this.elem > 1) {
            throw new EventDataException("getDouble called for array data: " + this.name);
        }
        if (!this.isMapped) {
            this.block.map(this);
        }
        return Hbook.getCWDataDouble(this.block.getBuffer(), this.offset, this.size);
    }

    int getInt() {
        if (this.type != 2 && this.type != 3) {
            throw new EventDataException("getInt called for non-integer data: " + this.name);
        }
        if (this.elem > 1) {
            throw new EventDataException("getInt called for array data: " + this.name);
        }
        if (!this.isMapped) {
            this.block.map(this);
        }
        return Hbook.getCWDataInt(this.block.getBuffer(), this.offset, this.size);
    }

    boolean getBoolean() {
        if (this.type != 4) {
            throw new EventDataException("getBoolean called for non-boolean data: " + this.name);
        }
        if (this.elem > 1) {
            throw new EventDataException("getBoolean called for array data: " + this.name);
        }
        if (!this.isMapped) {
            this.block.map(this);
        }
        return Hbook.getCWDataBoolean(this.block.getBuffer(), this.offset, this.size);
    }

    String getString() {
        if (this.type != 5) {
            throw new EventDataException("getString called for non-string data: " + this.name);
        }
        if (this.elem > 1) {
            throw new EventDataException("getString called for array data: " + this.name);
        }
        if (!this.isMapped) {
            this.block.map(this);
        }
        return Hbook.getCWDataString(this.block.getBuffer(), this.offset, this.size);
    }

    Object getObject() {
        if (this.array == null) {
            this.array = this.type == 1 ? new DoubleArray() : (this.type == 4 ? new BooleanArray() : (this.type == 5 ? new StringArray() : new IntegerArray()));
        }
        return this.array;
    }

    String getJASType() {
        if (this.elem > 1) {
            return arrayTypes[this.type];
        }
        return types[this.type];
    }

    Rebinnable1DHistogramData getRebinnable1DHistogramData() {
        if (this.type == 5) {
            ColumnwiseTuple columnwiseTuple = (ColumnwiseTuple)this.getParent();
            int n = columnwiseTuple.getID();
            StringPartition stringPartition = new StringPartition();
            long l = this.block.getBuffer();
            int n2 = columnwiseTuple.getTotalNumberOfEvents();
            if (!this.isMapped) {
                this.block.map(this);
            }
            int n3 = 0;
            while (n3 < n2) {
                Hbook.setCWEvent(n, ++n3);
                stringPartition.fill(Hbook.getCWDataString(l, this.offset, this.size));
            }
            return (Rebinnable1DHistogramData)PartitionAdapter.create((Partition)stringPartition, (String)this.toString());
        }
        return this;
    }

    public double getMin() {
        if (!this.minMaxKnown) {
            this.getMinMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minMaxKnown) {
            this.getMinMax();
        }
        return this.max;
    }

    private void getMinMax() {
        ColumnwiseTuple columnwiseTuple = (ColumnwiseTuple)this.getParent();
        int n = columnwiseTuple.getID();
        this.block.clearMap();
        this.block.map(this);
        double[] dArray = Hbook.CWgetMinMax(n, this.block.getBuffer(), this.offset, this.type, this.size, this.fixed, this.index != null ? this.index.offset : -1);
        this.min = dArray[0];
        this.max = dArray[1];
        this.minMaxKnown = true;
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        ColumnwiseTuple columnwiseTuple = (ColumnwiseTuple)this.getParent();
        int n2 = columnwiseTuple.getID();
        this.block.clearMap();
        this.block.map(this);
        double[] dArray = Hbook.CWrebin(n2, this.block.getBuffer(), this.offset, this.type, this.size, this.fixed, this.index != null ? this.index.offset : -1, n, d, d2);
        double[][] dArrayArray = new double[][]{dArray};
        return dArrayArray;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.name;
    }

    public boolean isRebinnable() {
        return true;
    }

    public int getBins() {
        return 40;
    }

    public int getAxisType() {
        return this.type != 2 && this.type != 3 ? 1 : 4;
    }

    public Statistics getStatistics() {
        return null;
    }

    private class BooleanArray
    extends Array
    implements PawBooleanArray {
        private BooleanArray() {
        }

        public boolean getBoolean(int n) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataBoolean(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n), ColumnwiseTupleField.this.size);
        }

        public boolean getBoolean(int n, int n2) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataBoolean(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n, n2), ColumnwiseTupleField.this.size);
        }

        public boolean getBoolean(int n, int n2, int n3) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataBoolean(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n, n2, n3), ColumnwiseTupleField.this.size);
        }

        public boolean getBoolean(int[] nArray) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataBoolean(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(nArray), ColumnwiseTupleField.this.size);
        }

        public boolean[] getAsJavaArray() {
            boolean[] blArray = new boolean[this.calcSize()];
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            int n = ColumnwiseTupleField.this.offset;
            int n2 = 0;
            while (n2 < blArray.length) {
                blArray[n2] = Hbook.getCWDataBoolean(ColumnwiseTupleField.this.block.getBuffer(), n, ColumnwiseTupleField.this.size);
                n += ColumnwiseTupleField.this.size;
                ++n2;
            }
            return blArray;
        }
    }

    private class StringArray
    extends Array
    implements PawStringArray {
        private StringArray() {
        }

        public String getString(int n) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataString(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n), ColumnwiseTupleField.this.size);
        }

        public String getString(int n, int n2) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataString(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n, n2), ColumnwiseTupleField.this.size);
        }

        public String getString(int n, int n2, int n3) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataString(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n, n2, n3), ColumnwiseTupleField.this.size);
        }

        public String getString(int[] nArray) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataString(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(nArray), ColumnwiseTupleField.this.size);
        }

        public String[] getAsJavaArray() {
            String[] stringArray = new String[this.calcSize()];
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            int n = ColumnwiseTupleField.this.offset;
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = Hbook.getCWDataString(ColumnwiseTupleField.this.block.getBuffer(), n, ColumnwiseTupleField.this.size);
                n += ColumnwiseTupleField.this.size;
                ++n2;
            }
            return stringArray;
        }
    }

    private class IntegerArray
    extends Array
    implements PawIntegerArray {
        private IntegerArray() {
        }

        public int getInt(int n) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataInt(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n), ColumnwiseTupleField.this.size);
        }

        public int getInt(int n, int n2) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataInt(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n, n2), ColumnwiseTupleField.this.size);
        }

        public int getInt(int n, int n2, int n3) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataInt(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n, n2, n3), ColumnwiseTupleField.this.size);
        }

        public int getInt(int[] nArray) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataInt(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(nArray), ColumnwiseTupleField.this.size);
        }

        public int[] getAsJavaArray() {
            int[] nArray = new int[this.calcSize()];
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            int n = ColumnwiseTupleField.this.offset;
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = Hbook.getCWDataInt(ColumnwiseTupleField.this.block.getBuffer(), n, ColumnwiseTupleField.this.size);
                n += ColumnwiseTupleField.this.size;
                ++n2;
            }
            return nArray;
        }
    }

    private class DoubleArray
    extends Array
    implements PawDoubleArray {
        private DoubleArray() {
        }

        public double getDouble(int n) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataDouble(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n), ColumnwiseTupleField.this.size);
        }

        public double getDouble(int n, int n2) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataDouble(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n, n2), ColumnwiseTupleField.this.size);
        }

        public double getDouble(int n, int n2, int n3) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataDouble(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(n, n2, n3), ColumnwiseTupleField.this.size);
        }

        public double getDouble(int[] nArray) {
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            return Hbook.getCWDataDouble(ColumnwiseTupleField.this.block.getBuffer(), this.calcOffset(nArray), ColumnwiseTupleField.this.size);
        }

        public double[] getAsJavaArray() {
            double[] dArray = new double[this.calcSize()];
            if (!ColumnwiseTupleField.this.isMapped) {
                ColumnwiseTupleField.this.block.map(ColumnwiseTupleField.this);
            }
            int n = ColumnwiseTupleField.this.offset;
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray[n2] = Hbook.getCWDataDouble(ColumnwiseTupleField.this.block.getBuffer(), n, ColumnwiseTupleField.this.size);
                n += ColumnwiseTupleField.this.size;
                ++n2;
            }
            return dArray;
        }
    }

    private class Array
    implements PawArray {
        private Array() {
        }

        public int getNDimensions() {
            return ColumnwiseTupleField.this.nsub;
        }

        public int getDimension(int n) {
            int n2 = ColumnwiseTupleField.this.dimension[n];
            if (n2 < 0) {
                n2 = ColumnwiseTupleField.this.index.getInt();
            }
            return n2;
        }

        int calcOffset(int n) {
            int[] nArray = new int[]{n};
            return this.calcOffset(nArray);
        }

        int calcOffset(int n, int n2) {
            int[] nArray = new int[]{n, n2};
            return this.calcOffset(nArray);
        }

        int calcOffset(int n, int n2, int n3) {
            int[] nArray = new int[]{n, n2, n3};
            return this.calcOffset(nArray);
        }

        int calcOffset(int[] nArray) {
            if (ColumnwiseTupleField.this.nsub != nArray.length) {
                throw new EventDataException("Wrong number of subscripts for PawArray: " + ColumnwiseTupleField.this.name);
            }
            int n = ColumnwiseTupleField.this.offset;
            int n2 = ColumnwiseTupleField.this.size;
            int n3 = 0;
            while (n3 < ColumnwiseTupleField.this.nsub) {
                int n4 = nArray[n3];
                int n5 = this.getDimension(n3);
                if (n4 < 1 || n4 > n5) {
                    throw new EventDataException("PawArray index out of range: " + ColumnwiseTupleField.this.name + " index=" + n4);
                }
                n += (n4 - 1) * n2;
                n2 *= n5;
                ++n3;
            }
            return n;
        }

        int calcSize() {
            int n = 1;
            int n2 = 0;
            while (n2 < ColumnwiseTupleField.this.nsub) {
                n *= this.getDimension(n2);
                ++n2;
            }
            return n;
        }
    }
}

