/*
 * Decompiled with CFR 0.152.
 */
package jasext.paw;

import hep.analysis.AbstractNTupleEventData;
import hep.analysis.EndOfDataException;
import hep.analysis.EventData;
import hep.analysis.EventDataException;
import hep.analysis.NTupleEventData;
import jasext.paw.ColumnwiseBlock;
import jasext.paw.ColumnwiseTupleField;
import jasext.paw.CompositeHObj;
import jasext.paw.Hbook;
import jasext.paw.TupleHObj;
import java.util.Enumeration;
import java.util.Hashtable;

class ColumnwiseTuple
extends TupleHObj {
    private int id;
    private Hashtable blocks = new Hashtable();
    int mapCount = 0;

    ColumnwiseTuple(CompositeHObj compositeHObj, String string, int n, int n2) {
        super(compositeHObj, string, 1, n);
        this.setEventData((NTupleEventData)new ColumnwiseEventData());
        this.id = n2;
    }

    public EventData getNextEvent() throws EndOfDataException {
        EventData eventData = super.getNextEvent();
        if (this.mapCount > 0) {
            Hbook.setCWEvent(this.id, this.ievent);
        }
        return eventData;
    }

    public void beforeFirstEvent() {
        super.beforeFirstEvent();
        Enumeration enumeration = this.blocks.elements();
        while (enumeration.hasMoreElements()) {
            ColumnwiseBlock columnwiseBlock = (ColumnwiseBlock)enumeration.nextElement();
            columnwiseBlock.clearMap();
        }
    }

    int getID() {
        return this.id;
    }

    ColumnwiseBlock getBlock(String string) {
        ColumnwiseBlock columnwiseBlock = (ColumnwiseBlock)this.blocks.get(string);
        if (columnwiseBlock != null) {
            return columnwiseBlock;
        }
        columnwiseBlock = new ColumnwiseBlock(this.id, string, this);
        this.blocks.put(string, columnwiseBlock);
        return columnwiseBlock;
    }

    public String toString() {
        String string = "CW Tuple: " + this.name + " (" + this.nChildren() + " columns " + this.getTotalNumberOfEvents() + " rows)";
        return string;
    }

    public void close() {
        super.close();
        Enumeration enumeration = this.blocks.elements();
        while (enumeration.hasMoreElements()) {
            ColumnwiseBlock columnwiseBlock = (ColumnwiseBlock)enumeration.nextElement();
            columnwiseBlock.close();
        }
        Hbook.delete(this.id);
    }

    private class ColumnwiseEventData
    extends AbstractNTupleEventData {
        private ColumnwiseEventData() {
        }

        public double getDouble(String string) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(string);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return columnwiseTupleField.getDouble();
        }

        public int getInt(String string) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(string);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return columnwiseTupleField.getInt();
        }

        public boolean getBoolean(String string) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(string);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return columnwiseTupleField.getBoolean();
        }

        public String getString(String string) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(string);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return columnwiseTupleField.getString();
        }

        public Object getObject(String string) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(string);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return columnwiseTupleField.getObject();
        }

        public double getDouble(int n) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(n);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + n);
            }
            return columnwiseTupleField.getDouble();
        }

        public int getInt(int n) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(n);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + n);
            }
            return columnwiseTupleField.getInt();
        }

        public boolean getBoolean(int n) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(n);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + n);
            }
            return columnwiseTupleField.getBoolean();
        }

        public String getString(int n) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(n);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + n);
            }
            return columnwiseTupleField.getString();
        }

        public Object getObject(int n) {
            ColumnwiseTupleField columnwiseTupleField = (ColumnwiseTupleField)ColumnwiseTuple.this.getChild(n);
            if (columnwiseTupleField == null) {
                throw new EventDataException("Can not find column " + n);
            }
            return columnwiseTupleField.getObject();
        }

        public int findColumn(String string) {
            try {
                return ColumnwiseTuple.this.getIndex(string);
            }
            catch (Exception exception) {
                throw new EventDataException("Can not find column " + string);
            }
        }
    }
}

