/*
 * Decompiled with CFR 0.152.
 */
package jas.demos.stocks;

import jas.demos.stocks.AxisModel;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ZoomSlider
extends JSlider {
    private static final int daysToSeconds = 86400;

    ZoomSlider(AxisModel axisModel) {
        super(new ZoomModel(axisModel));
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        ((Dictionary)dict).put(new Integer(ZoomSlider.valueForDays(1825)), new JLabel("5 Years"));
        ((Dictionary)dict).put(new Integer(ZoomSlider.valueForDays(365)), new JLabel("1 Year"));
        ((Dictionary)dict).put(new Integer(ZoomSlider.valueForDays(91)), new JLabel("3 Months"));
        ((Dictionary)dict).put(new Integer(ZoomSlider.valueForDays(30)), new JLabel("1 Month"));
        ((Dictionary)dict).put(new Integer(ZoomSlider.valueForDays(7)), new JLabel("1 Week"));
        this.setLabelTable(dict);
        this.setOrientation(1);
        this.setPaintLabels(true);
        this.setBorder(BorderFactory.createTitledBorder("Zoom"));
    }

    private static int valueForSeconds(int seconds) {
        return ZoomSlider.valueForDays(seconds / 86400);
    }

    private static int secondsForValue(int value) {
        return 86400 * ZoomSlider.daysForValue(value);
    }

    private static int valueForDays(int days) {
        return (int)(100.0 * Math.log(days));
    }

    private static int daysForValue(int value) {
        return (int)Math.exp((double)value / 100.0);
    }

    private static class ZoomModel
    extends DefaultBoundedRangeModel
    implements ChangeListener {
        private AxisModel axisModel;
        private boolean waggingDog = true;

        ZoomModel(AxisModel axisModel) {
            this.axisModel = axisModel;
            axisModel.addChangeListener(this);
            this.setMinimum(ZoomSlider.valueForDays(7));
            this.setMaximum(ZoomSlider.valueForSeconds(axisModel.getMaximum() - axisModel.getMinimum()));
            this.setValue(ZoomSlider.valueForSeconds(axisModel.getExtent()));
            this.waggingDog = false;
        }

        public void stateChanged(ChangeEvent event) {
            this.waggingDog = true;
            this.setValue(ZoomSlider.valueForSeconds(this.axisModel.getExtent()));
            this.waggingDog = false;
        }

        protected void fireStateChanged() {
            if (!this.waggingDog) {
                this.axisModel.setExtent(ZoomSlider.secondsForValue(this.getValue()));
            }
            super.fireStateChanged();
        }
    }
}

