/*
 * Decompiled with CFR 0.152.
 */
package jas.demos.stocks;

import jas.hist.Rebinnable1DHistogramData;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class StockPrices
implements Rebinnable1DHistogramData {
    private String title;
    private Date[] date;
    private float[] high;
    private float[] low;
    private float[] close;
    private int[] volume;
    static final DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

    public StockPrices(InputStream file) throws IOException {
        LineNumberReader in = new LineNumberReader(new InputStreamReader(file));
        try {
            try {
                this.title = in.readLine();
                int n = Integer.parseInt(in.readLine());
                this.date = new Date[n];
                this.high = new float[n];
                this.low = new float[n];
                this.close = new float[n];
                this.volume = new int[n];
                int i = 0;
                while (i < n) {
                    String line = in.readLine();
                    StringTokenizer tokens = new StringTokenizer(line, ",");
                    this.date[i] = dateFormat.parse(tokens.nextToken());
                    if (tokens.countTokens() == 4) {
                        this.high[i] = Float.parseFloat(tokens.nextToken());
                        this.low[i] = Float.parseFloat(tokens.nextToken());
                        this.close[i] = Float.parseFloat(tokens.nextToken());
                        this.volume[i] = Integer.parseInt(tokens.nextToken());
                    }
                    ++i;
                }
            }
            catch (IOException x) {
                throw x;
            }
            catch (Throwable throwable) {
                throw new IOException("Error parsing file at line " + in.getLineNumber());
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public int getBins() {
        return 100;
    }

    public boolean isRebinnable() {
        return true;
    }

    public int getAxisType() {
        return 3;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public double getMax() {
        return (double)this.date[0].getTime() / 1000.0;
    }

    public double getMin() {
        return (double)this.date[this.date.length - 1].getTime() / 1000.0;
    }

    public String getTitle() {
        return this.title;
    }

    public double[][] rebin(int bins, double xmin, double xmax, boolean wantErrors, boolean hurry) {
        double[] mean = new double[bins];
        double[] min = new double[bins];
        double[] max = new double[bins];
        int[] n = new int[bins];
        int i = 0;
        while (i < this.date.length) {
            double time;
            int bin;
            if (this.volume[i] != 0 && (bin = (int)Math.floor((double)bins * ((time = (double)this.date[i].getTime() / 1000.0) - xmin) / (xmax - xmin))) >= 0 && bin < bins) {
                int n2 = bin;
                int n3 = n[n2];
                n[n2] = n3 + 1;
                if (n3 == 0) {
                    min[bin] = this.low[i];
                    max[bin] = this.high[i];
                    mean[bin] = this.close[i];
                } else {
                    min[bin] = Math.min(min[bin], (double)this.low[i]);
                    max[bin] = Math.max(max[bin], (double)this.high[i]);
                    int n4 = bin;
                    mean[n4] = mean[n4] + (double)this.close[i];
                }
            }
            ++i;
        }
        i = 0;
        while (i < bins) {
            int n5 = i;
            mean[n5] = mean[n5] / (double)n[i];
            max[i] = max[i] - mean[i];
            min[i] = mean[i] - min[i];
            ++i;
        }
        return new double[][]{mean, max, min};
    }
}

