/*
 * Decompiled with CFR 0.152.
 */
package jas.demos.stocks;

import jas.demos.stocks.AxisModel;
import jas.demos.stocks.StockPrices;
import jas.demos.stocks.ZoomSlider;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Main
extends JPanel
implements ChangeListener {
    private JASHist plot = new JASHist();
    private AxisModel model;
    private boolean modelIsChangingAxis = false;
    private boolean axisIsChangingModel = false;
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy");

    private Main() throws Exception {
        super(new BorderLayout());
        this.plot.setAllowUserInteraction(false);
        StockPrices sp1 = new StockPrices(this.getClass().getResourceAsStream("MSFT.CSV"));
        StockPrices sp2 = new StockPrices(this.getClass().getResourceAsStream("AAPL.CSV"));
        1 sp3 = new 1(this.getClass().getResourceAsStream("SUNW.CSV"));
        this.addData((DataSource)sp1, Color.blue);
        this.addData((DataSource)sp2, Color.red);
        this.addData((DataSource)sp3, Color.green);
        JPanel plotPanel = new JPanel(new BorderLayout());
        this.add((Component)plotPanel, "Center");
        this.plot.setPreferredSize(new Dimension(500, 300));
        this.plot.setDataAreaColor(Color.white);
        this.plot.setDataAreaBorder(BorderFactory.createLineBorder(Color.black));
        this.plot.setTitle("Stock Price Demo");
        plotPanel.add((Component)this.plot, "Center");
        int min = (int)(format.parse("1997").getTime() / 1000L);
        int max = (int)(format.parse("2002").getTime() / 1000L);
        this.model = new AxisModel(min, max);
        this.model.addChangeListener(this);
        ZoomSlider zoom = new ZoomSlider(this.model);
        this.add((Component)zoom, "East");
        JScrollBar scroll = new JScrollBar();
        scroll.setModel(this.model);
        scroll.setOrientation(0);
        scroll.setUnitIncrement(86400);
        scroll.setBlockIncrement(31536000);
        plotPanel.add((Component)scroll, "South");
        JLabel label = new JLabel("<html><center><font color=\"black\">The plot shows the min, max and average stock price in each time bin. Use the zoom slider to control the range of the plot, and use the scroll bar at the bottom to scroll through the data. You can also drag on the X axis.");
        label.setPreferredSize(new Dimension(150, 300));
        this.add((Component)label, "West");
    }

    private void addData(DataSource ds, Color color) {
        JASHistData d = this.plot.addData(ds);
        JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
        style.setShowHistogramBars(false);
        style.setShowDataPoints(true);
        style.setErrorBarColor(color);
        style.setDataPointColor(color);
        d.setStyle((JASHistStyle)style);
        d.show(true);
    }

    private void axisChanged(double min, double max) {
        if (!this.modelIsChangingAxis) {
            this.axisIsChangingModel = true;
            this.model.setValueIsAdjusting(true);
            this.model.setValue((int)min);
            this.model.setExtent((int)(max - min));
            this.model.setValueIsAdjusting(false);
            this.axisIsChangingModel = false;
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.axisIsChangingModel) {
            JASHistAxis axis = this.plot.getXAxis();
            this.modelIsChangingAxis = true;
            axis.setRange((double)this.model.getValue(), (double)(this.model.getValue() + this.model.getExtent()));
            this.modelIsChangingAxis = false;
        }
    }

    public static void main(String[] argv) throws Exception {
        JFrame frame = new JFrame("Stock Prices Demo");
        Main main = new Main();
        frame.setContentPane(new Main());
        frame.addWindowListener(new 2());
        frame.pack();
        frame.show();
    }

    private final class 1
    extends StockPrices {
        public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
            Main.this.axisChanged(min, max);
            return super.rebin(bins, min, max, wantErrors, hurry);
        }

        /* synthetic */ 1(InputStream p$1) throws IOException {
            super(p$1);
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }

        /* synthetic */ 2() {
        }
    }
}

