/*
 * Decompiled with CFR 0.152.
 */
package jas.util.xml.parserwrappers;

import jas.util.xml.JASDOMParser;
import java.io.IOException;
import java.io.Reader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XercesDOMParser
extends JASDOMParser {
    private int level = 0;

    public Document parse(Reader reader, String string) throws JASDOMParser.XMLException {
        return this.parse(reader, string, null);
    }

    public Document parse(Reader reader, final String string, EntityResolver entityResolver) throws JASDOMParser.XMLException {
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature("http://xml.org/sax/features/validation", true);
            dOMParser.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) {
                    System.err.println(string + ": Warning at line " + sAXParseException.getLineNumber() + ": " + sAXParseException);
                    if (XercesDOMParser.this.level < 1) {
                        XercesDOMParser.this.level = 1;
                    }
                }

                public void error(SAXParseException sAXParseException) {
                    System.err.println(string + ": Error at line " + sAXParseException.getLineNumber() + ": " + sAXParseException);
                    if (XercesDOMParser.this.level < 2) {
                        XercesDOMParser.this.level = 2;
                    }
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    System.err.println(string + ": Fatal error at line " + sAXParseException.getLineNumber() + ": " + sAXParseException);
                    if (XercesDOMParser.this.level < 3) {
                        XercesDOMParser.this.level = 3;
                    }
                    throw sAXParseException;
                }
            });
            if (entityResolver != null) {
                dOMParser.setEntityResolver(entityResolver);
            }
            dOMParser.parse(new InputSource(reader));
            if (this.level > 1) {
                throw new SAXException("Error during XML file parsing");
            }
            return dOMParser.getDocument();
        }
        catch (SAXException sAXException) {
            throw new JASDOMParser.XMLException("Syntax error parsing XML file", sAXException);
        }
        catch (IOException iOException) {
            throw new JASDOMParser.XMLException("IO error parsing XML file", iOException);
        }
    }
}

