/*
 * Decompiled with CFR 0.152.
 */
package jas.util.pluginmanager;

import jas.util.Application;
import jas.util.pluginmanager.PluginManagerUI;
import jas.util.pluginmanager.PluginProperties;
import jas.util.pluginmanager.PluginXMLReader;
import jas.util.pluginmanager.VersionNumberCompare;
import jas.util.xml.JASDOMParser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginManager
implements ActionListener {
    private Vector availablelist;
    private Vector pluginsloadedatstartup = new Vector();
    private PluginXMLReader xmlreader;
    private static final String jaspluginfile = "jasplugin.xml";
    private static final String jasdtdfile = "jasplugin.dtd";
    private String userdir;
    private String systemdir;
    private boolean readpluginXMLOK;

    public PluginManager(String string, String string2) {
        this.userdir = string2;
        this.systemdir = string;
    }

    public String getSystemDirectory() {
        return this.systemdir;
    }

    public String getUserDirectory() {
        return this.userdir;
    }

    private void addAvailablePluginList(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL[] uRLArray, int n, String[] stringArray, String string8, boolean bl, boolean bl2) {
        PluginProperties pluginProperties = new PluginProperties(string, string2, string3, string4, string5, string6, string7, uRLArray, n, stringArray, string8, bl, bl2);
        this.availablelist.addElement(pluginProperties);
    }

    private void addAvailablePluginList(PluginProperties pluginProperties) {
        this.availablelist.addElement(pluginProperties);
    }

    public void setPluginLoadedAtStart(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string, string2, string3, string4};
        this.pluginsloadedatstartup.addElement(stringArray);
    }

    protected void removeAvailablePluginList(PluginProperties pluginProperties) {
        this.availablelist.removeElement(pluginProperties);
    }

    protected Vector getLoadedPluginList() {
        Vector vector = new Vector();
        if (!this.availablelist.isEmpty()) {
            int n = 0;
            while (n < this.availablelist.size()) {
                if (((PluginProperties)this.availablelist.elementAt((int)n)).state == 1) {
                    vector.addElement(this.availablelist.elementAt(n));
                }
                ++n;
            }
        }
        return vector;
    }

    protected Vector getAvailablePluginList() {
        return this.availablelist;
    }

    protected Vector getNotInstalledPluginList() {
        Vector vector = new Vector();
        if (!this.availablelist.isEmpty()) {
            int n = 0;
            while (n < this.availablelist.size()) {
                if (((PluginProperties)this.availablelist.elementAt((int)n)).installable & ((PluginProperties)this.availablelist.elementAt((int)n)).state == 0) {
                    vector.addElement(this.availablelist.elementAt(n));
                }
                ++n;
            }
        }
        return vector;
    }

    public void initializePluginList() {
        Object object;
        try {
            object = new URL("http://jas.freehep.org/plugins/jasplugin.xml");
            this.xmlreader = new PluginXMLReader(new InputStreamReader(((URL)object).openStream()), jaspluginfile, jasdtdfile);
        }
        catch (IOException iOException) {
            Object[] objectArray = new String[]{"OK"};
            int n = JOptionPane.showOptionDialog(Application.getApplication().getParent(), "Error initializing plugin manager: " + iOException, "Plugin Manager", -1, 0, null, objectArray, objectArray[0]);
            this.readpluginXMLOK = false;
            return;
        }
        catch (JASDOMParser.XMLException xMLException) {
            Object[] objectArray = new String[]{"OK"};
            int n = JOptionPane.showOptionDialog(Application.getApplication().getParent(), "Error initializing plugin manager: " + xMLException, "Plugin Manager", -1, 0, null, objectArray, objectArray[0]);
            this.readpluginXMLOK = false;
            return;
        }
        this.availablelist = new Vector();
        object = this.xmlreader.getPluginNodeList();
        String string = null;
        int n = 0;
        Vector<URL> vector = new Vector<URL>();
        URL uRL = null;
        Vector<String> vector2 = new Vector<String>();
        int n2 = 1;
        while (n2 < object.getLength()) {
            Node node = object.item(n2);
            if (node.getNodeName().compareTo("Plugin") == 0) {
                Object object2;
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string2 = namedNodeMap.getNamedItem("Name").getNodeValue();
                String string3 = namedNodeMap.getNamedItem("Author").getNodeValue();
                String string4 = namedNodeMap.getNamedItem("LatestVersion").getNodeValue();
                String string5 = namedNodeMap.getNamedItem("Requirements").getNodeValue();
                String string6 = namedNodeMap.getNamedItem("MinJASVersion").getNodeValue();
                boolean bl = namedNodeMap.getNamedItem("Removeable").getNodeValue().compareTo("False") != 0;
                NodeList nodeList = node.getChildNodes();
                int n3 = 1;
                while (n3 < nodeList.getLength()) {
                    Node node2 = nodeList.item(n3);
                    if (node2.getNodeName().equals("Downloads")) {
                        NamedNodeMap namedNodeMap2 = node2.getAttributes();
                        String string7 = namedNodeMap2.getNamedItem("File").getNodeValue();
                        try {
                            uRL = new URL(namedNodeMap2.getNamedItem("URLDownload").getNodeValue());
                        }
                        catch (MalformedURLException malformedURLException) {
                            System.out.println("Malformed url: urldownload " + malformedURLException);
                        }
                        vector.addElement(uRL);
                        vector2.addElement(string7);
                    } else if (node2.getNodeName().equals("Description")) {
                        string = node2.getFirstChild().getNodeValue();
                        object2 = new StringBuffer();
                        int n4 = string.length();
                        int n5 = 0;
                        while (n5 < n4) {
                            if (string.charAt(n5) != '\t' && (n5 + 1 >= n4 || string.charAt(n5) != ' ' || string.charAt(n5 + 1) != ' ')) {
                                if (n5 == n4 - 1 && string.charAt(n5) == ' ') break;
                                if (string.charAt(n5) == '\r' || string.charAt(n5) == '\n') {
                                    ((StringBuffer)object2).append(' ');
                                } else {
                                    ((StringBuffer)object2).append(string.charAt(n5));
                                }
                            }
                            ++n5;
                        }
                        string = ((StringBuffer)object2).toString();
                    }
                    ++n3;
                }
                object2 = new URL[vector.size()];
                vector.copyInto((Object[])object2);
                vector.removeAllElements();
                Object[] objectArray = new String[vector2.size()];
                vector2.copyInto(objectArray);
                vector2.removeAllElements();
                this.addAvailablePluginList(null, string2, string3, null, string, string4, string5, (URL[])object2, n, (String[])objectArray, string6, bl, true);
            }
            ++n2;
        }
        this.checkLoadedAtStart();
        this.readpluginXMLOK = true;
    }

    public boolean getReadPluginXMLOK() {
        return this.readpluginXMLOK;
    }

    private void checkLoadedAtStart() {
        boolean bl = false;
        int n = 0;
        while (n < this.pluginsloadedatstartup.size()) {
            String[] stringArray = (String[])this.pluginsloadedatstartup.elementAt(n);
            String[] stringArray2 = new String[]{stringArray[3]};
            bl = false;
            int n2 = 0;
            while (n2 < this.availablelist.size()) {
                PluginProperties pluginProperties = (PluginProperties)this.availablelist.elementAt(n2);
                if (pluginProperties.name.compareTo(stringArray[0]) == 0) {
                    pluginProperties.currversion = stringArray[1];
                    pluginProperties.setState(1);
                    pluginProperties.path = stringArray[2];
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                this.addAvailablePluginList(stringArray[2], stringArray[0], null, null, null, null, null, null, 1, stringArray2, null, true, false);
            }
            ++n;
        }
    }

    protected Vector getOutDatedPluginList() {
        Vector vector = new Vector();
        VersionNumberCompare versionNumberCompare = new VersionNumberCompare();
        if (this.availablelist != null) {
            int n = 0;
            while (n < this.availablelist.size()) {
                PluginProperties pluginProperties = (PluginProperties)this.availablelist.elementAt(n);
                if (pluginProperties.state == 1 & pluginProperties.installable & pluginProperties.currversion.compareTo("unknown") != 0 & pluginProperties.latestversion.compareTo("unknown") != 0) {
                    try {
                        int n2 = versionNumberCompare.compareVersions(pluginProperties.currversion, pluginProperties.latestversion, true);
                        if (n2 == 1) {
                            vector.addElement(this.availablelist.elementAt(n));
                        }
                    }
                    catch (VersionNumberCompare.VersionCompareException versionCompareException) {
                        System.out.println(versionCompareException + " For plugin " + pluginProperties.name + ": an element of the latest version number was < coressponding current version element. ");
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    public void showPluginManager() {
        PluginManagerUI pluginManagerUI = new PluginManagerUI(this);
        pluginManagerUI.showManagerGUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "pluginmanager") {
            this.showPluginManager();
        }
    }

    class FrameClosing
    extends WindowAdapter {
        FrameClosing() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

