/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Application;
import jas.util.UserProperties;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class JASEditableComboBox
extends JComboBox
implements KeyListener {
    private int m_minWidth = -1;
    private int m_maxWidth = -1;
    private int m_nItems;
    private String[] m_dropDownItems;
    private String m_key = null;
    private JTextField m_textField;
    private ChangeEvent m_changeEvent = null;
    private UserProperties m_prop = null;
    private boolean m_clickDefault;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JASEditableComboBox(String[] stringArray, boolean bl) {
        this.m_clickDefault = bl;
        this.init(stringArray);
    }

    public JASEditableComboBox(String string, int n, boolean bl) {
        this.m_clickDefault = bl;
        this.m_prop = Application.getApplication().getUserProperties();
        this.m_nItems = n;
        this.m_key = string;
        this.init(this.m_prop.getStringArray(this.m_key, null));
    }

    public JASEditableComboBox(String string, String string2, boolean bl) {
        this(string, Application.getApplication().getUserProperties().getInteger(string2, 4), bl);
    }

    private void init(String[] stringArray) {
        this.m_dropDownItems = stringArray;
        if (this.m_dropDownItems != null) {
            int n = 0;
            while (n < this.m_dropDownItems.length) {
                this.addItem(this.m_dropDownItems[n]);
                ++n;
            }
        }
        this.setEditable(true);
        this.m_textField = (JTextField)this.getEditor().getEditorComponent();
        this.m_textField.addKeyListener(this);
    }

    public void saveState() {
        if (this.m_key != null) {
            this.m_prop.setStringArray(this.m_key, UserProperties.updateStringArray(this.m_dropDownItems, this.getText(), this.m_nItems));
        }
    }

    public String getText() {
        return this.m_textField.getText();
    }

    public void setText(String string) {
        if (string.equals(this.getItemAt(0))) {
            return;
        }
        this.removeItem(string);
        this.insertItemAt(string, 0);
        this.setSelectedIndex(0);
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.m_textField != null) {
            this.m_textField.addKeyListener(keyListener);
        }
    }

    public final void keyReleased(KeyEvent keyEvent) {
    }

    public final void keyPressed(KeyEvent keyEvent) {
        JButton jButton;
        if (keyEvent.getSource() != this.m_textField) {
            return;
        }
        this.fireStateChanged();
        if (keyEvent.getKeyCode() == 10 && this.m_clickDefault && (jButton = this.getRootPane().getDefaultButton()) != null) {
            jButton.doClick();
        }
    }

    private void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? JASEditableComboBox.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.m_changeEvent == null) {
                    this.m_changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.m_changeEvent);
            }
            n -= 2;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JASEditableComboBox.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_textField.addActionListener(actionListener);
    }

    protected final void fireItemStateChanged(ItemEvent itemEvent) {
        super.fireItemStateChanged(itemEvent);
        this.fireStateChanged();
    }

    public final void requestFocus() {
        this.m_textField.requestFocus();
    }

    public final void keyTyped(KeyEvent keyEvent) {
    }

    public final void setMaxWidth(int n) {
        this.m_maxWidth = n;
    }

    public final void setMinWidth(int n) {
        this.m_minWidth = n;
    }

    public final Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (this.m_maxWidth > 0 && this.m_maxWidth < dimension.width) {
            dimension.width = this.m_maxWidth;
        }
        return dimension;
    }

    public final Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (this.m_minWidth > 0 && this.m_minWidth > dimension.width) {
            dimension.width = this.m_minWidth;
        }
        return dimension;
    }

    public final Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.m_minWidth > 0 && this.m_minWidth > dimension.width) {
            dimension.width = this.m_minWidth;
        }
        if (this.m_maxWidth > 0 && this.m_maxWidth < dimension.width) {
            dimension.width = this.m_maxWidth;
        }
        return dimension;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

