/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Application;
import jas.util.JASState;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JASDialog
extends JDialog
implements MouseListener,
DocumentListener {
    public static final int OK_BUTTON = 1;
    public static final int APPLY_BUTTON = 2;
    public static final int CANCEL_BUTTON = 4;
    public static final int HELP_BUTTON = 8;
    private Application app = Application.getApplication();
    private String m_helpTopic = null;
    private int m_flags;
    private JPanel m_buttonPanel;
    private JButton m_ok;
    private JButton m_cancel;
    private JButton m_apply;
    private JButton m_help;
    private boolean m_result;
    private Frame m_frame;
    private Container m_contentPane;

    public JASDialog(Frame frame, String string) {
        this(frame, string, true, 5);
    }

    public JASDialog(Frame frame, String string, boolean bl) {
        this(frame, string, bl, 5);
    }

    public JASDialog(Frame frame, String string, boolean bl, int n) {
        super(frame, string, bl);
        this.m_frame = frame;
        this.m_flags = n;
        ActionEventHandler actionEventHandler = new ActionEventHandler();
        this.m_ok = new JButton("OK");
        this.m_ok.addActionListener(actionEventHandler);
        this.m_ok.setMnemonic('O');
        this.m_apply = new JButton("Apply");
        this.m_apply.setMnemonic('A');
        this.m_apply.addActionListener(actionEventHandler);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setMnemonic('C');
        this.m_cancel.addActionListener(actionEventHandler);
        this.m_help = new JButton("Help");
        this.m_help.setMnemonic('H');
        this.m_help.addActionListener(actionEventHandler);
        this.m_buttonPanel = new JPanel();
        super.getContentPane().add((Component)this.m_buttonPanel, "South");
        this.enableEvents(64L);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        super.getContentPane().add((Component)jPanel, "Center");
        this.m_contentPane = jPanel;
    }

    public void pack() {
        this.defaultPack();
        this.setLocationRelativeTo(this.m_frame);
    }

    public void defaultPack() {
        if (this.m_buttonPanel.getComponentCount() == 0) {
            if ((this.m_flags & 1) != 0) {
                this.m_buttonPanel.add(this.m_ok);
            }
            if ((this.m_flags & 2) != 0) {
                this.m_buttonPanel.add(this.m_apply);
            }
            if ((this.m_flags & 4) != 0) {
                this.m_buttonPanel.add(this.m_cancel);
            }
            if ((this.m_flags & 8) != 0) {
                this.m_buttonPanel.add(this.m_help);
            }
        }
        super.pack();
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.onCancel();
        }
        super.processEvent(aWTEvent);
    }

    public boolean doModal() {
        this.m_result = false;
        this.setModal(true);
        this.show();
        return this.m_result;
    }

    public void show() {
        this.callEnable();
        if (this.isModal() && this.app != null) {
            this.app.modalDialogOpening(this);
        }
        super.show();
        if (this.isModal() && this.app != null) {
            this.app.modalDialogClosing(this);
        }
    }

    public void setOKLabel(String string) {
        this.m_ok.setText(string);
    }

    public void setOKMnemonic(char c) {
        this.m_ok.setMnemonic(c);
    }

    public void setCancelLabel(String string) {
        this.m_cancel.setText(string);
    }

    public void setCancelMnemonic(char c) {
        this.m_cancel.setMnemonic(c);
    }

    public void setApplyLabel(String string) {
        this.m_apply.setText(string);
    }

    public void setApplyMnemonic(char c) {
        this.m_apply.setMnemonic(c);
    }

    protected void onOK() {
        this.m_result = true;
        this.dispose();
    }

    protected void onCancel() {
        this.dispose();
    }

    protected void onApply() {
    }

    protected void callEnable() {
        if (this.m_ok != null) {
            this.enableOK(new ButtonState(this.m_ok));
            this.getRootPane().setDefaultButton(this.m_ok);
        }
        if (this.m_apply != null) {
            this.enableApply(new ButtonState(this.m_apply));
        }
        if (this.m_help != null) {
            this.enableHelp(new ButtonState(this.m_help));
        }
    }

    protected void enableOK(JASState jASState) {
    }

    protected void enableHelp(JASState jASState) {
        jASState.setEnabled(this.m_helpTopic != null);
    }

    protected void enableApply(JASState jASState) {
        jASState.setEnabled(false);
    }

    public Container getContentPane() {
        return this.m_contentPane;
    }

    public void setContentPane(Container container) {
        this.m_contentPane = container;
        super.getContentPane().add((Component)this.m_contentPane, "Center");
    }

    public final void setHelpTopic(String string) {
        this.m_flags |= 8;
        this.m_helpTopic = string;
    }

    private void onHelp() {
        Application.getApplication().showHelpTopic(this.m_helpTopic, this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.callEnable();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.callEnable();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.callEnable();
    }

    private class ButtonState
    implements JASState {
        private JButton m_button;

        ButtonState(JButton jButton) {
            this.m_button = jButton;
        }

        public void setEnabled(boolean bl) {
            this.m_button.setEnabled(bl);
        }
    }

    private class ActionEventHandler
    implements ActionListener {
        private ActionEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JASDialog.this.m_ok) {
                JASDialog.this.onOK();
            } else if (object == JASDialog.this.m_apply) {
                JASDialog.this.onApply();
            } else if (object == JASDialog.this.m_cancel) {
                JASDialog.this.onCancel();
            } else if (object == JASDialog.this.m_help) {
                JASDialog.this.onHelp();
            }
        }
    }
}

