/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio.adaptor;

import hep.analysis.NamedObject;
import jas.hist.JASHist;
import jas.job.PlotAccess;
import jas.swingstudio.JASException;
import jas.swingstudio.JASPage;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.TreeAdaptor;
import jas.util.JASMenuItem;
import jas.util.JASState;
import jas.util.OnScreenPopupMenu;
import javax.swing.JPopupMenu;

public class PlotTreeAdaptor
extends TreeAdaptor {
    private static JPopupMenu menu;
    private PlotAccess m_plot;

    protected void init() {
        this.m_plot = (PlotAccess)this.getAssociatedObject();
    }

    protected void updateNode(int n) {
        if ((n & 0x80000) != 0) {
            this.onShow();
        }
    }

    public void onShowInNewPlot() {
        JASPage jASPage = JavaAnalysisStudio.getApp().getCurrentPage();
        jASPage.addPlot();
        JASHist jASHist = jASPage.getCurrentPlot();
        int n = this.m_plot.getNDataSources();
        int n2 = 0;
        while (n2 < n) {
            jASHist.addData(this.m_plot.getData(n2)).show(true);
            ++n2;
        }
        JASPage.calculateTitlesAndLabels(jASHist);
        jASPage.currentPlotUpdated();
    }

    public void enableShowInNewPlot(JASState jASState) {
        jASState.setEnabled(JavaAnalysisStudio.getApp().getCurrentPage() != null);
    }

    public void onShowOnNewPage() {
        JASPage jASPage = JavaAnalysisStudio.getApp().createNewPage();
        JASHist jASHist = jASPage.getCurrentPlot();
        int n = this.m_plot.getNDataSources();
        int n2 = 0;
        while (n2 < n) {
            jASHist.addData(this.m_plot.getData(n2)).show(true);
            ++n2;
        }
        JASPage.calculateTitlesAndLabels(jASHist);
        jASPage.currentPlotUpdated();
    }

    public void onDoubleClick() throws JASException {
        this.onShow();
    }

    public void onShow() {
        JASPage jASPage = JavaAnalysisStudio.getApp().createCurrentPage();
        if (jASPage != null) {
            JASHist jASHist = jASPage.getCurrentPlot();
            jASHist.removeAllData();
            int n = this.m_plot.getNDataSources();
            int n2 = 0;
            while (n2 < n) {
                jASHist.addData(this.m_plot.getData(n2)).show(true);
                ++n2;
            }
            JASPage.calculateTitlesAndLabels(jASHist);
            jASPage.currentPlotUpdated();
        }
    }

    public void onDelete() {
        this.m_plot.delete();
    }

    public void onRename() {
        this.startEditing();
    }

    public boolean stopEditing(String string) {
        try {
            this.m_plot.rename(string);
            return true;
        }
        catch (NamedObject.RenameException renameException) {
            JavaAnalysisStudio.getApp().error("Illegal name", renameException);
            return false;
        }
    }

    protected boolean isEditable() {
        return true;
    }

    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = new OnScreenPopupMenu();
            menu.add(new JASMenuItem("Show", 'S'));
            menu.add(new JASMenuItem("Show In New Plot", 'P'));
            menu.add(new JASMenuItem("Show On New Page", 'N'));
            menu.add(new JASMenuItem("Rename", 'R'));
            menu.add(new JASMenuItem("Delete", 'D'));
        }
        return menu;
    }
}

