/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio.adaptor;

import hep.analysis.NamedObject;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Rebinnable2DHistogramData;
import jas.job.HistogramAccess;
import jas.swingstudio.JASPage;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.TreeAdaptor;
import jas.swingstudio.adaptor.OneDTreeData;
import jas.swingstudio.adaptor.ScatterTreeData;
import jas.util.JASCheckboxMenuItem;
import jas.util.JASCheckboxState;
import jas.util.JASMenuItem;
import jas.util.JASState;
import jas.util.OnScreenPopupMenu;
import javax.swing.JPopupMenu;

public class HistogramAccessTreeAdaptor
extends TreeAdaptor {
    private static JPopupMenu menu;
    private HistogramAccess m_hist = null;
    private DataSource m_data;

    protected void init() {
        this.m_hist = (HistogramAccess)this.getAssociatedObject();
        this.reset();
    }

    protected void updateNode(int n) {
        if ((n & 0x80000) != 0) {
            if (JavaAnalysisStudio.getApp().getCurrentPage() != null) {
                this.onShowInNewPlot();
            } else {
                this.onShowOnNewPage();
            }
        }
        if ((n & 0x100000) != 0) {
            this.reset();
        }
    }

    private void reset() {
        DataSource dataSource = this.m_hist.getData();
        if (dataSource instanceof Rebinnable1DHistogramData) {
            this.m_data = new OneDTreeData(this.getTreeItem(), (Rebinnable1DHistogramData)dataSource);
        } else if (dataSource instanceof Rebinnable2DHistogramData) {
            this.m_data = new ScatterTreeData(this.getTreeItem(), (Rebinnable2DHistogramData)dataSource);
        }
    }

    public void onShowInNewPlot() {
        JASPage jASPage = JavaAnalysisStudio.getApp().getCurrentPage();
        jASPage.addPlot();
        JASHist jASHist = jASPage.getCurrentPlot();
        jASHist.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(jASHist);
        jASPage.currentPlotUpdated();
    }

    public void enableShowInNewPlot(JASState jASState) {
        jASState.setEnabled(this.m_data != null && JavaAnalysisStudio.getApp().getCurrentPage() != null);
    }

    public void onShowOnNewPage() {
        JASPage jASPage = JavaAnalysisStudio.getApp().createNewPage();
        JASHist jASHist = jASPage.getCurrentPlot();
        jASHist.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(jASHist);
        jASPage.currentPlotUpdated();
    }

    public void enableShowOnNewPage(JASState jASState) {
        jASState.setEnabled(this.m_data != null);
    }

    public void onShow() {
        JASPage jASPage = JavaAnalysisStudio.getApp().createCurrentPage();
        if (jASPage != null) {
            JASHist jASHist = jASPage.getCurrentPlot();
            jASHist.removeAllData();
            jASHist.addData(this.m_data).show(true);
            JASPage.calculateTitlesAndLabels(jASHist);
            jASPage.currentPlotUpdated();
        }
    }

    public void enableShow(JASState jASState) {
        jASState.setEnabled(this.m_data != null);
    }

    public void onOverlay() {
        JASPage jASPage = JavaAnalysisStudio.getApp().getCurrentPage();
        JASHist jASHist = jASPage.getCurrentPlot();
        jASHist.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(jASHist);
        jASPage.currentPlotUpdated();
    }

    public void enableOverlay(JASState jASState) {
        JASPage jASPage = JavaAnalysisStudio.getApp().getCurrentPage();
        if (jASPage != null && this.m_data != null) {
            JASHist jASHist = jASPage.getCurrentPlot();
            jASState.setEnabled(jASHist.getNumberOfDataSources() > 0);
        } else {
            jASState.setEnabled(false);
        }
    }

    public void onDelete() {
        this.m_hist.delete();
    }

    public void onRename() {
        this.startEditing();
    }

    public boolean stopEditing(String string) {
        try {
            this.m_hist.rename(string);
            return true;
        }
        catch (NamedObject.RenameException renameException) {
            JavaAnalysisStudio.getApp().error("Illegal name", renameException);
            return false;
        }
    }

    public void enableClearOnRewind(JASCheckboxState jASCheckboxState) {
        jASCheckboxState.setEnabled(this.m_hist.canSetClearOnRewind());
        jASCheckboxState.setCheckbox(this.m_hist.isClearOnRewind());
    }

    public void onClearOnRewind(boolean bl) {
        this.m_hist.setClearOnRewind(bl);
    }

    public void onClear() {
        this.m_hist.clear();
    }

    public void onDoubleClick() {
        if (this.m_data != null) {
            this.onShow();
        }
    }

    public void onSelect() {
        JavaAnalysisStudio.getApp().setMessage(this.m_hist.getDescription());
    }

    protected boolean isEditable() {
        return true;
    }

    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = new OnScreenPopupMenu();
            menu.add(new JASMenuItem("Show", 'S'));
            menu.add(new JASMenuItem("Overlay", 'O'));
            menu.add(new JASMenuItem("Show In New Plot", 'P'));
            menu.add(new JASMenuItem("Show On New Page", 'N'));
            menu.add(new JASMenuItem("Clear", 'C'));
            menu.add(new JASCheckboxMenuItem("Clear On Rewind", 'W'));
            menu.add(new JASMenuItem("Rename", 'R'));
            menu.add(new JASMenuItem("Delete", 'D'));
        }
        return menu;
    }
}

