/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.RecentItemsMenu;
import jas.util.UserProperties;
import java.io.File;

public class RecentFilesMenu
extends RecentItemsMenu {
    private final JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private final UserProperties m_prop = this.m_app.getUserProperties();
    static final String length_Key = "MaxFileListLength";
    static final String includePath_Key = "InclPath-Files";

    public RecentFilesMenu() {
        super(length_Key);
    }

    public void addNotify() {
        super.addNotify();
        this.setEnabled(this.m_app.getLastFiles());
    }

    protected void itemSelected(String string) {
        try {
            this.m_app.openFile(new File(string));
        }
        catch (Exception exception) {
            this.m_app.error("Cannot open file " + string, exception);
        }
    }

    protected String toDisplayFormat(String string) {
        int n;
        if (!this.m_prop.getBoolean(includePath_Key, true) && (n = string.lastIndexOf(File.separator)) >= 0) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }
}

